/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.net;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.mediatek.mcs.Mcs;

public class RequestManager
extends Application {
    public static final String TAG = RequestManager.class.getSimpleName();
    private static RequestManager mInstance;
    private RequestQueue mRequestQueue;

    public static synchronized RequestManager getInstance() {
        if (mInstance == null) {
            mInstance = new RequestManager();
        }
        return mInstance;
    }

    public static void sendInBackground(Request request) {
        RequestManager.getInstance().addToRequestQueue(request, Mcs.getApplicationContext());
    }

    public void onCreate() {
        super.onCreate();
        mInstance = this;
    }

    public RequestQueue getRequestQueue(Context ctx) {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)ctx);
        }
        return this.mRequestQueue;
    }

    public <T> void addToRequestQueue(Request<T> req, String tag, Context ctx) {
        req.setTag((Object)(TextUtils.isEmpty((CharSequence)tag) ? TAG : tag));
        this.getRequestQueue(ctx).add(req);
    }

    public <T> void addToRequestQueue(Request<T> req, Context ctx) {
        req.setTag((Object)TAG);
        this.getRequestQueue(ctx).add(req);
    }

    public void cancelPendingRequests(Object tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.cancelAll(tag);
        }
    }
}

