package com.mediatek.mcs.entity;

import com.mediatek.mcs.domain.McsGeoPoint;

/**
 * MCS API schema for parsing data point.
 *
 * class Values could also be used to wrap your
 * to-be-uploaded data with correct format.
 */
public class DataPointEntity extends McsEntity {
  private Long recordedAt;
  private Values values;

  /**
   * @return timeMillis
   */
  public Long getRecordedAt() {
    return recordedAt;
  }

  public Values getValues() {
    return values;
  }

  public static class Values {
    private String value;
    private String period;
    private Float latitude;
    private Float longitude;
    private Float altitude;

    /**
     * Wrap data with only value.
     */
    public Values(String value) {
      this.value = value;
    }

    /**
     * Wrap data with both value and period.
     */
    public Values(String value, String period) {
      this.value = value;
      this.period = period;
    }

    /**
     * Wrap GPS-type data
     */
    public Values(float lat, float lng, float altitude) {
      this.latitude = lat;
      this.longitude = lng;
      this.altitude = altitude;
    }

    public Values(McsGeoPoint geoPoint) {
      this.latitude = geoPoint.getLatitude();
      this.longitude = geoPoint.getLongitude();
      this.altitude = geoPoint.getAltitude();
    }

    public String getValue() {
      return value;
    }

    public String getPeriod() {
      return period;
    }

    public Float getLatitude() {
      return latitude;
    }

    public Float getLongitude() {
      return longitude;
    }

    public Float getAltitude() {
      return altitude;
    }
  }
}
