/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.push;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.push.PushService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class McsPushBroadcastReceiver
extends BroadcastReceiver {
    static final String ACTION_RECEIVE = "com.mediatek.mcs.push.intent.RECEIVE";
    static final String ACTION_OPEN = "com.mediatek.mcs.push.intent.OPEN";
    static final String ACTION_DISMISS = "com.mediatek.mcs.push.intent.DISMISS";
    static final String KEY_PUSH_DATA = "pushData";
    static final String PROPERTY_PUSH_ICON = "com.mediatek.mcs.push.notification_icon";
    static final int NOTIFICATION_ID = 1;

    public void onReceive(Context context, Intent intent) {
        McsLog.d(context.getPackageName() + ": " + intent.getAction(), new Object[0]);
        if (ACTION_RECEIVE.equals(intent.getAction())) {
            this.onPushReceive(context, intent);
        } else if (ACTION_OPEN.equals(intent.getAction())) {
            this.onPushOpen(context, intent);
        } else if (ACTION_DISMISS.equals(intent.getAction())) {
            this.onPushDismiss(context, intent);
        }
    }

    protected void onPushReceive(Context context, Intent intent) {
        this.getNotification(context, intent);
    }

    protected void onPushOpen(Context context, Intent intent) {
        Class<? extends Activity> clazz = this.getActivity(context, intent);
        if (clazz != null) {
            Intent intent2 = new Intent(context, clazz);
            intent2.addFlags(0x10000000);
            context.startActivity(intent2);
        }
    }

    protected void onPushDismiss(Context context, Intent intent) {
    }

    protected void getNotification(Context context, Intent intent) {
        this.onMessageReceived(context, this.parseNotif(intent));
    }

    protected void onMessageReceived(Context context, String message) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setAutoCancel(true).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message)).setWhen(System.currentTimeMillis()).setDefaults(-1).setSmallIcon(this.getSmallIconId(context)).setContentTitle((CharSequence)context.getString(context.getApplicationInfo().labelRes)).setContentText((CharSequence)message).setContentIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_OPEN), (int)0)).setDeleteIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_DISMISS), (int)0));
        notificationManager.notify(1, builder.build());
    }

    protected Class<? extends Activity> getActivity(Context context, Intent intent) {
        return PushService.setDefaultPushCallback();
    }

    protected int getSmallIconId(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            return bundle.getInt(PROPERTY_PUSH_ICON);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return R.drawable.default_notif_icon;
        }
    }

    private String parseNotif(Intent intent) {
        try {
            String string2 = intent.getBundleExtra(KEY_PUSH_DATA).getString("alert");
            return string2 == null ? "" : URLDecoder.decode(string2, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            McsLog.e("generateNotification:" + unsupportedEncodingException.getMessage(), new Object[0]);
            return "";
        }
    }
}

