/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.android.volley.Request;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.domain.McsPushInstallation;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.domain.f;
import com.mediatek.mcs.domain.g;
import com.mediatek.mcs.domain.h;
import com.mediatek.mcs.domain.i;
import com.mediatek.mcs.domain.j;
import com.mediatek.mcs.entity.AuthEntity;
import com.mediatek.mcs.entity.ResponseMessage;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.net.SignInRequest;
import com.mediatek.mcs.pref.McsUser;
import com.mediatek.mcs.pref.McsUserInfo;
import org.json.JSONObject;

public class McsSession {
    private static McsSession INSTANCE = new McsSession();
    protected McsResponse.SuccessListener<JSONObject> successListener;
    protected McsResponse.ErrorListener errorListener;

    protected McsSession() {
    }

    public static McsSession getInstance() {
        return INSTANCE;
    }

    public McsUser getCurrentUser() {
        return McsUser.getInstance();
    }

    public boolean isSignedIn() {
        return !"".equals(this.getCurrentUser().getToken());
    }

    public String getAccessToken() {
        return McsUser.getInstance().getAccessToken();
    }

    public McsUserInfo getUserInfo() {
        return McsUserInfo.getInstance();
    }

    public void saveTokenResultsToPref(AuthEntity.AccessToken.Results results) {
        McsUser.getInstance().setEmail(results.getEmail());
        McsUser.getInstance().setToken(results.getToken());
        McsUser.getInstance().setAccessToken(results.getAccessToken());
        McsUser.getInstance().savePref();
        McsUserInfo.getInstance().setNickname(results.getNickname());
        McsUserInfo.getInstance().setUserImageURL(results.getUserImageURL());
        McsUserInfo.getInstance().savePref();
    }

    public void requestSignIn(McsResponse.SuccessListener<JSONObject> successListener) {
        this.requestSignIn(successListener, f.a());
    }

    public void requestSignIn(McsResponse.SuccessListener<JSONObject> successListener, McsResponse.ErrorListener errorListener) {
        this.successListener = successListener;
        this.errorListener = errorListener;
        if (this.isValidAuth()) {
            this.requestSignInToken();
        }
    }

    public void requestSignOut(McsResponse.SuccessListener<JSONObject> successListener) {
        McsPushInstallation.getInstance().requestUnRegisterMobile(this.getAccessToken());
        McsUser.getInstance().clearPref();
        McsUserInfo.getInstance().clearPref();
        successListener.onSuccess(ResponseMessage.create("Sign out successfully"));
    }

    private void requestSignInToken() {
        RequestManager.sendInBackground(new SignInRequest(1, RequestApi.POST_LOGIN_TOKEN, SignInRequest.getSignInParams(), g.a(this), h.a(this)));
    }

    protected void requestUserInfo() {
        RequestManager.sendInBackground((Request)new McsJsonRequest(RequestApi.GET_USER_INFO, i.a(this), j.a(this)));
    }

    protected boolean isValidAuth() {
        boolean bl = false;
        if ("".equals(Mcs.MCS_APP_KEY) || "".equals(Mcs.MCS_APP_SECRET)) {
            this.errorListener.onError(new SdkInstallationException(R.string.error_install_credential_invalid));
        } else {
            bl = true;
        }
        return bl;
    }

    private /* synthetic */ void lambda$requestUserInfo$11(Exception error) {
        this.errorListener.onError(RequestUtils.parseVolleyError(error));
    }

    private /* synthetic */ void lambda$requestUserInfo$10(JSONObject response) {
        McsUserInfo.getInstance().saveToPref(response);
        if (McsPushInstallation.getInstance().isRegistered()) {
            try {
                McsPushInstallation.getInstance().requestRegisterMobile(this.successListener, this.errorListener);
            }
            catch (SdkInstallationException sdkInstallationException) {
                this.errorListener.onError(sdkInstallationException);
            }
        } else {
            this.successListener.onSuccess(ResponseMessage.create("Sign in without register mobile"));
        }
    }

    private /* synthetic */ void lambda$requestSignInToken$9(Exception error) {
        this.errorListener.onError(RequestUtils.parseVolleyError(error));
    }

    private /* synthetic */ void lambda$requestSignInToken$8(JSONObject response) {
        McsUser.getInstance().saveToPref(response);
        this.requestUserInfo();
    }

    private static /* synthetic */ void lambda$requestSignIn$7(Exception error) {
        McsLog.e(error.getMessage(), new Object[0]);
    }

    static /* synthetic */ void access$lambda$0(Exception exception) {
        McsSession.lambda$requestSignIn$7(exception);
    }

    static /* synthetic */ void access$lambda$1(McsSession mcsSession, JSONObject jSONObject) {
        mcsSession.lambda$requestSignInToken$8(jSONObject);
    }

    static /* synthetic */ void access$lambda$2(McsSession mcsSession, Exception exception) {
        mcsSession.lambda$requestSignInToken$9(exception);
    }

    static /* synthetic */ void access$lambda$3(McsSession mcsSession, JSONObject jSONObject) {
        mcsSession.lambda$requestUserInfo$10(jSONObject);
    }

    static /* synthetic */ void access$lambda$4(McsSession mcsSession, Exception exception) {
        mcsSession.lambda$requestUserInfo$11(exception);
    }
}

