package com.mediatek.mcs.pref;

import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.entity.McsMobileEntity;
import org.json.JSONObject;

public final class McsMobile implements McsPreferences {

  private static final String USER_INFO_MOBILE_ID = "USER_INFO_MOBILE_ID";
  private static McsMobile INSTANCE = new McsMobile();
  private Gson gson = new Gson();
  private SharedPreferences pref;
  private String mobileId;

  private McsMobile() {
    pref = PreferenceManager.getDefaultSharedPreferences(Mcs.getApplicationContext());

    this.mobileId = pref.getString(USER_INFO_MOBILE_ID, "");
  }

  public static McsMobile getInstance() {
    return INSTANCE;
  }

  public void clearPref() {
    this.mobileId = "";
    savePref();
  }

  public void savePref() {
    Editor editor = pref.edit();
    editor.putString(USER_INFO_MOBILE_ID, this.mobileId);
    editor.commit();
  }

  public void saveToPref(JSONObject response) {
    saveUserMobile(gson.fromJson(response.toString(), McsMobileEntity.class));
  }

  private void saveUserMobile(McsMobileEntity mobile) {
    this.setMobileId(mobile.getMobileId());
    this.savePref();
  }

  public String getMobileId() {
    return mobileId;
  }

  public void setMobileId(String mobileId) {
    this.mobileId = mobileId;
  }
}
