package com.mediatek.mcs.entity.api;

import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.ProductEntity;
import com.mediatek.mcs.net.RequestApi;
import java.util.Date;
import java.util.List;

public class DeviceInfoEntity extends ApiResults<DeviceInfoEntity> {
  private String deviceId;
  private String deviceKey;
  private String deviceName;
  private String deviceDescription;

  private String trustIpRange;
  private String lastIp;
  private String deviceImageURL;

  private boolean isVerified;
  private boolean isActive;
  private boolean isTest;
  private Date activatedAt;
  private Date deactivatedAt;

  private String privilege;
  private ProductEntity product;
  private Firmware fw;
  private List<DataChannelEntity> dataChannels;

  public String getDeviceImageURL() {
    return ("productBanner.jpg".equals(deviceImageURL) || "".equals(deviceImageURL)) ? ""
        : RequestApi.getImageServerPrefix() + deviceImageURL;
  }

  public Firmware getFw() {
    return fw;
  }

  public String getDeviceId() {
    return deviceId;
  }

  public String getDeviceKey() {
    return deviceKey;
  }

  public String getDeviceName() {
    return deviceName;
  }

  public String getDeviceDescription() {
    return deviceDescription;
  }

  public String getTrustIpRange() {
    return trustIpRange;
  }

  public String getLastIp() {
    return lastIp;
  }

  public boolean isVerified() {
    return isVerified;
  }

  public boolean isActive() {
    return isActive;
  }

  public boolean isTest() {
    return isTest;
  }

  public Date getActivatedAt() {
    return activatedAt;
  }

  public Date getDeactivatedAt() {
    return deactivatedAt;
  }

  public String getPrivilege() {
    return privilege;
  }

  public ProductEntity getProduct() {
    return product;
  }

  public List<DataChannelEntity> getDataChannels() {
    return dataChannels;
  }

  public class Firmware {
    private String fwId;
    private String description;
    private String version;
    private String name;

    public String getFwId() {
      return fwId;
    }

    public String getDescription() {
      return description;
    }

    public String getVersion() {
      return version;
    }

    public String getName() {
      return name;
    }
  }
}
