package com.mediatek.mcs.entity;

public class RegisterMobileEntity extends McsEntity {
  private String name;
  private String regToken;
  private String appKey;
  private int mobileTypeId;
  private Info info;

  public RegisterMobileEntity(String name, String regToken, String appKey, Info info) {
    this.name = name;
    this.regToken = regToken;
    this.appKey = appKey;
    this.mobileTypeId = 1;  // 1 stands for Android device.
    this.info = info;
  }

  public static class Info {
    private String mcsAppId;
    private String mcsClientKey;
    private String manufacturer;
    private String model;
    private String appIdentifier;
    private String appName;
    private String appVersionName;
    private int appVersionCode;
    private int sdkVersion;
    private ScreenMetrics metrics;

    public Info(String mcsAppId, String mcsClientKey, String manufacturer, String model,
        String appIdentifier, String appName, String appVersionName,
        int appVersionCode, int sdkVersion, ScreenMetrics metrics) {
      this.mcsAppId = mcsAppId;
      this.mcsClientKey = mcsClientKey;
      this.manufacturer = manufacturer;
      this.model = model;
      this.appIdentifier = appIdentifier;
      this.appName = appName;
      this.appVersionName = appVersionName;
      this.appVersionCode = appVersionCode;
      this.sdkVersion = sdkVersion;
      this.metrics = metrics;
    }

    public ScreenMetrics getMetrics() {
      return metrics;
    }

    public void setMetrics(ScreenMetrics metrics) {
      this.metrics = metrics;
    }

    public static class ScreenMetrics {
      private float density;
      private int widthPixels;
      private int heightPixels;
      private double diagonalInches;

      public ScreenMetrics(float density, int widthPixels, int heightPixels,
          double diagonalInches) {
        this.density = density;
        this.widthPixels = widthPixels;
        this.heightPixels = heightPixels;
        this.diagonalInches = diagonalInches;
      }
    }
  }
}
