package com.mediatek.mcs.domain;

import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.AuthEntity;
import com.mediatek.mcs.entity.ResponseMessage;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.net.SignInRequest;
import com.mediatek.mcs.pref.McsUser;
import com.mediatek.mcs.pref.McsUserInfo;
import org.json.JSONObject;

public class McsSession {

  private static McsSession INSTANCE = new McsSession();
  protected McsResponse.SuccessListener<JSONObject> successListener;
  protected McsResponse.ErrorListener errorListener;
  protected McsSession() {

  }

  public static McsSession getInstance() {
    return INSTANCE;
  }

  public McsUser getCurrentUser() {
    return McsUser.getInstance();
  }

  public boolean isSignedIn() {
    return !"".equals(getCurrentUser().getToken());
  }

  public String getAccessToken() {
    return McsUser.getInstance().getAccessToken();
  }

  public McsUserInfo getUserInfo() {
    return McsUserInfo.getInstance();
  }

  public void saveTokenResultsToPref(AuthEntity.AccessToken.Results results) {
    McsUser.getInstance().setEmail(results.getEmail());
    McsUser.getInstance().setToken(results.getToken());
    McsUser.getInstance().setAccessToken(results.getAccessToken());
    McsUser.getInstance().savePref();

    McsUserInfo.getInstance().setNickname(results.getNickname());
    McsUserInfo.getInstance().setUserImageURL(results.getUserImageURL());
    McsUserInfo.getInstance().savePref();
  }

  /**
   * Request Methods
   */
  public void requestSignIn(McsResponse.SuccessListener<JSONObject> successListener) {
    this.requestSignIn(successListener, (error) -> McsLog.e(error.getMessage()));
  }

  public void requestSignIn(McsResponse.SuccessListener<JSONObject> successListener,
      McsResponse.ErrorListener errorListener) {
    this.successListener = successListener;
    this.errorListener = errorListener;

    if (isValidAuth()) {
      requestSignInToken();
    }
  }

  public void requestSignOut(McsResponse.SuccessListener<JSONObject> successListener) {
    McsPushInstallation.getInstance().requestUnRegisterMobile(getAccessToken());

    McsUser.getInstance().clearPref();
    McsUserInfo.getInstance().clearPref();
    successListener.onSuccess(ResponseMessage.create("Sign out successfully"));
  }

  private void requestSignInToken() {
    RequestManager.sendInBackground(new SignInRequest(
        McsJsonRequest.Method.POST,
        RequestApi.POST_LOGIN_TOKEN,
        SignInRequest.getSignInParams(),
        response -> {
          McsUser.getInstance().saveToPref(response);

          requestUserInfo();
        },
        error -> errorListener.onError(RequestUtils.parseVolleyError(error))
    ));
  }

  protected void requestUserInfo() {
    RequestManager.sendInBackground(new McsJsonRequest(
        RequestApi.GET_USER_INFO,
        response -> {
          McsUserInfo.getInstance().saveToPref(response);

          if (McsPushInstallation.getInstance().isRegistered()) {
            try {
              McsPushInstallation.getInstance()
                  .requestRegisterMobile(successListener, errorListener);
            } catch (SdkInstallationException e) {
              errorListener.onError(e);
            }
          } else {
            successListener.onSuccess(ResponseMessage.create("Sign in without register mobile"));
          }
        },
        error -> errorListener.onError(RequestUtils.parseVolleyError(error))
    ));
  }

  protected boolean isValidAuth() {
    boolean isValid = false;

    if ("".equals(Mcs.MCS_APP_KEY) || "".equals(Mcs.MCS_APP_SECRET)) {
      errorListener.onError(new SdkInstallationException(R.string.error_install_credential_invalid));
    } else {
      isValid = true;
    }
    return isValid;
  }
}
