package com.mediatek.mcs.domain;

import android.text.TextUtils;
import com.android.volley.AuthFailureError;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.entity.ResponseMessage;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.pref.McsMobile;
import com.mediatek.mcs.push.PushRegistration;
import java.util.Map;
import org.json.JSONObject;

public final class McsPushInstallation {

  public static final int PUSH_GCM = 101;
  private static McsPushInstallation INSTANCE = new McsPushInstallation();
  private boolean isRegistered;
  private boolean isUpdateRegId;
  private String gcmSenderId;
  private String appKey;
  private String regId;
  private McsPushInstallation() {
    this.appKey = "";
    this.isRegistered = false;
    this.isUpdateRegId = false;
  }

  public static McsPushInstallation getInstance() {
    return INSTANCE;
  }

  public void registerInBackground(String gcm_sender_id, String gcm_api_key) {
    this.isRegistered = true;
    this.gcmSenderId = gcm_sender_id;
    this.appKey = gcm_api_key;
    try {
      new PushRegistration(gcm_sender_id, gcm_api_key);
    } catch (SdkInstallationException e) {
      McsLog.e(e.getMessage());
    }
  }

  public void setup(String regId, String appKey) {
    this.regId = regId;
    this.appKey = appKey;
    /**
     * setIsUpdateRegId(GcmPreference.getInstance().isUpdateRegId());
     */
  }

  /**
   * Required {@link McsPushInstallation#setup(String, String)
   * McsPushInstallation setup} method in advanced
   */
  public void requestRegisterMobile(McsResponse.SuccessListener<JSONObject> successListener,
      McsResponse.ErrorListener errorListener) throws SdkInstallationException {
    if (!PushRegistration.isPushInstalled(gcmSenderId, appKey)
        || TextUtils.isEmpty(regId)) {
      registerInBackground(gcmSenderId, appKey);
      return ;
    }

    int method;
    String url;

    if (isUpdateRegId) {
      McsLog.d("Update mobile");
      method = McsJsonRequest.Method.PUT;
      url = RequestApi.UPDATE_MOBILE
          .replace("{mobileId}", McsMobile.getInstance().getMobileId());
    } else {
      McsLog.d("Register mobile");
      method = McsJsonRequest.Method.POST;
      url = RequestApi.REGISTER_MOBILE;
    }

    RequestManager.sendInBackground(new McsJsonRequest(
        method,
        url,
        new McsRegisterMobile().toString(),
        response -> {
          McsMobile.getInstance().saveToPref(response);
          successListener.onSuccess(ResponseMessage.create("register mobile success"));
        },
        errorListener::onError
    ));
  }

  public void requestUnRegisterMobile(String accessToken) {
    if (TextUtils.isEmpty(McsMobile.getInstance().getMobileId())) {
      McsLog.e("mobileId is empty, still sign out.");
      return ;
    }

    RequestManager.sendInBackground(new McsJsonRequest(
        McsJsonRequest.Method.DELETE,
        RequestApi.UPDATE_MOBILE
            .replace("{mobileId}", McsMobile.getInstance().getMobileId()),
        response -> {
          McsMobile.getInstance().clearPref();
          McsLog.d("mobile unregistered.");
        }) {
      @Override public Map<String, String> getHeaders() throws AuthFailureError {
        return RequestUtils.getSignOutHeader(accessToken);
      }
    });
  }

  public boolean isRegistered() {
    return isRegistered;
  }

  public boolean isUpdateRegId() {
    return isUpdateRegId;
  }

  public void setIsUpdateRegId(boolean isUpdateRegId) {
    this.isUpdateRegId = isUpdateRegId;
  }

  public String getAppKey() {
    return appKey;
  }

  public String getRegId() {
    return regId;
  }
}
