package com.mediatek.mcs.domain;

import com.google.gson.Gson;
import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.exception.InvalidDataPointException;

public class McsGeoPoint {
  private float latitude;
  private float longitude;
  private float altitude;

  public McsGeoPoint(DataPointEntity.Values values) throws InvalidDataPointException {
    this(Float.toString(values.getLatitude()),
        Float.toString(values.getLongitude()),
        Float.toString(values.getAltitude()));
  }

  public McsGeoPoint(String latString, String lngString, String altString)
      throws InvalidDataPointException {

    if ("".equals(latString) || "".equals(lngString)) {
      throw new InvalidDataPointException(R.string.error_invalid_upload_value);
    }

    if ("".equals(altString)) {
      altString = "0";
    }

    try {
      float latitude = Float.parseFloat(latString);
      float longitude = Float.parseFloat(lngString);
      float altitude = Float.parseFloat(altString);

      if(-180.0f <= longitude && longitude < 180.0f) {
        this.longitude = longitude;
      } else {
        this.longitude = ((longitude - 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f;
      }

      this.latitude = Math.max(-90.0f, Math.min(90.0f, latitude));
      this.altitude = altitude;

    } catch (NumberFormatException e) {
      throw new InvalidDataPointException(R.string.error_invalid_upload_dp, e);
    }
  }

  public McsGeoPoint trim() throws InvalidDataPointException {
    this.latitude = Float.parseFloat(DataPointFormatter.trimGeoValue(latitude));
    this.longitude = Float.parseFloat(DataPointFormatter.trimGeoValue(longitude));
    this.altitude = Float.parseFloat(DataPointFormatter.trimGeoValue(altitude));

    return this;
  }

  public float getLatitude() {
    return this.latitude;
  }

  public float getLongitude() {
    return this.longitude;
  }

  public float getAltitude() {
    return this.altitude;
  }

  public String toString() {
    return new Gson().toJson(this);
  }
}
