package com.mediatek.mcs.domain;

import com.google.gson.Gson;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.entity.DataPointEntity.Values;
import com.mediatek.mcs.entity.DataPointsUploadEntity;
import com.mediatek.mcs.entity.DataPointsUploadEntity.DataPoint;
import com.mediatek.mcs.entity.api.DeviceInfoEntity;
import com.mediatek.mcs.event.DataPointEvent;
import com.mediatek.mcs.exception.InvalidDataPointException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.socket.McsSocketListener;
import de.greenrobot.event.EventBus;
import org.json.JSONException;
import org.json.JSONObject;

public class McsDataChannel {

  String mDeviceId;
  String mDeviceKey;
  DataChannelEntity mDataChannelEntity;
  McsSocketListener socketListener;

  public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity,
      McsSocketListener listener) {
    this.mDeviceId = device.getDeviceId();
    this.mDeviceKey = device.getDeviceKey();
    this.mDataChannelEntity = channelEntity;

    this.socketListener = listener;
  }

  public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity) {
    this(device, channelEntity, null);

    this.socketListener = new McsSocketListener(response -> {
      try {
        JSONObject data = response.getJSONObject("updateDatapoint");
        DataPointEntity dp = new Gson().fromJson(data.toString(), DataPointEntity.class);

        setDataPointEntity(dp);
      } catch (JSONException e) {
        McsLog.e(e.toString());
      }
    });
  }

  public McsSocketListener getMcsSocketListener() {
    return socketListener;
  }

  public String getDeviceId() {
    return mDeviceId;
  }

  public String getDeviceKey() {
    return mDeviceKey;
  }

  public String getChannelId() {
    return mDataChannelEntity.getDataChnId();
  }

  public String getChannelName() {
    return mDataChannelEntity.getName();
  }

  public boolean isControllable() {
    return mDataChannelEntity.isControllable();
  }

  public DataChannelEntity getDataChannelEntity() {
    return mDataChannelEntity;
  }

  public DataPointEntity getDataPointEntity() {
    return mDataChannelEntity.getDataPoint();
  }

  public void setDataPointEntity(DataPointEntity dp) {
    if (dp != null) {
      mDataChannelEntity.setDataPoint(dp);
      EventBus.getDefault().post(new DataPointEvent(getChannelId(), dp));
    }
  }

  public void submitCurrentDataPoint() {
    submitDataPoint(getDataPointEntity().getValues());
  }

  /**
   * Submit given values, and pack it automatically by channelType.
   */
  public void submitDataPoint(Values values) {
    try {
      Values formattedValues = DataPointFormatter.formatValues(getDataChannelEntity(), values);
      String body = new Gson().toJson(
          new DataPointsUploadEntity(
              new DataPoint(getChannelId(), formattedValues)
          )
      );
      requestUploadDataPointForBase(body);
    } catch (InvalidDataPointException e) {
      UIUtils.toast(e.getMessage());
    }
  }

  public void requestUploadDataPointForBase(final String requestBody) {
    RequestManager.sendInBackground(new McsJsonRequest(
        McsJsonRequest.Method.POST,
        RequestApi.UPLOAD_DATA_POINT
            .replace("{deviceId}", mDeviceId),
        requestBody,
        response -> {
          McsLog.d(response.toString());
          /**
           * Do nothing here.
           * Use socket to update view instead.
           */
        }
    ));
  }
}
