package com.mediatek.mcs.domain;

import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity.Values;
import com.mediatek.mcs.exception.InvalidDataPointException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

import static com.mediatek.mcs.domain.McsDataChannelType.CATEGORY;
import static com.mediatek.mcs.domain.McsDataChannelType.FLOAT;
import static com.mediatek.mcs.domain.McsDataChannelType.GPIO;
import static com.mediatek.mcs.domain.McsDataChannelType.GPS;
import static com.mediatek.mcs.domain.McsDataChannelType.HEX;
import static com.mediatek.mcs.domain.McsDataChannelType.INT;
import static com.mediatek.mcs.domain.McsDataChannelType.PWM;
import static com.mediatek.mcs.domain.McsDataChannelType.PWM_DISPLAY;
import static com.mediatek.mcs.domain.McsDataChannelType.PWM_SLIDER;
import static com.mediatek.mcs.domain.McsDataChannelType.STRING;
import static com.mediatek.mcs.domain.McsDataChannelType.SWITCH_EDIT;
import static com.mediatek.mcs.domain.McsDataChannelType.SWITCH_VIEW;
import static com.mediatek.mcs.domain.McsDataChannelType.getChannelType;

public class DataPointFormatter {

  /**
   * Get formatted values for upload data point.
   */
  public static Values formatValues(DataChannelEntity channel, Values values)
      throws InvalidDataPointException {
    if (values == null) throw new InvalidDataPointException(R.string.error_invalid_upload_dp);

    switch (getChannelType(channel)) {
      case INT:
      case FLOAT:
        return getFormatValues(values.getValue());
      case HEX:
      case STRING:
        return values;
      case GPS:
        return new Values(
            new McsGeoPoint(values).trim()
        );
      case PWM:
      case PWM_SLIDER:
        return getFormatValues(values.getValue(), values.getPeriod());
      case GPIO:
      case CATEGORY:
      case SWITCH_EDIT:
        return values;
      case SWITCH_VIEW:
      case PWM_DISPLAY:
      default:
        return null;
    }
  }

  public static Values getFormatValues(String value)
      throws InvalidDataPointException {
    return new Values(
        formatDecimal(value)
    );
  }

  public static Values getFormatValues(String value, String period)
      throws InvalidDataPointException {
    return new Values(
        formatDecimal(value),
        formatDecimal(period)
    );
  }

  private static String formatDecimal(final String decimalString)
      throws InvalidDataPointException {
    try {
      // remove leading zeros and leading plus
      String formattedString = decimalString.replaceFirst("^0+(?!$)", "");

      DecimalFormat formatter = (DecimalFormat) NumberFormat.getInstance();
      formatter.setMinimumIntegerDigits(1);
      formatter.setMaximumFractionDigits(16);
      formatter.setGroupingUsed(false);

      return formatter.format(Double.parseDouble(formattedString));
    } catch (Exception e) {
      throw new InvalidDataPointException(R.string.error_invalid_upload_dp, e);
    }
  }

  public static String trimGeoValue(Object value) throws InvalidDataPointException {
    try {
      final DecimalFormat df = new DecimalFormat("#.######");
      df.setRoundingMode(RoundingMode.HALF_EVEN);

      value = Float.parseFloat(value.toString());
      return df.format(value);
    } catch (NumberFormatException e) {
      throw new InvalidDataPointException(R.string.error_invalid_upload_dp, e);
    }
  }
}
