/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.apache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mdsol.mauth.AuthenticatorConfiguration;
import com.mdsol.mauth.Signer;
import com.mdsol.mauth.exception.HttpClientPublicKeyProviderException;
import com.mdsol.mauth.util.MAuthKeysHelper;
import com.mdsol.mauth.utils.ClientPublicKeyProvider;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientPublicKeyProvider
implements ClientPublicKeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientPublicKeyProvider.class);
    private final AuthenticatorConfiguration configuration;
    private final Signer signer;
    private final CloseableHttpClient httpclient;
    private final PublicKeyResponseHandler publicKeyResponseHandler;
    private final LoadingCache<UUID, PublicKeyData> publicKeyCache;

    public HttpClientPublicKeyProvider(AuthenticatorConfiguration authenticatorConfiguration, Signer signer) {
        this.configuration = authenticatorConfiguration;
        this.signer = signer;
        this.httpclient = HttpClients.createDefault();
        this.publicKeyResponseHandler = new PublicKeyResponseHandler();
        this.publicKeyCache = this.setupCache();
    }

    private LoadingCache<UUID, PublicKeyData> setupCache() {
        return Caffeine.newBuilder().expireAfter((Expiry)new Expiry<UUID, PublicKeyData>(){

            public long expireAfterCreate(UUID uUID, PublicKeyData publicKeyData, long l) {
                return TimeUnit.SECONDS.toNanos(publicKeyData.getMaxAgeSeconds());
            }

            public long expireAfterUpdate(UUID uUID, PublicKeyData publicKeyData, long l, long l2) {
                return l2;
            }

            public long expireAfterRead(UUID uUID, PublicKeyData publicKeyData, long l, long l2) {
                return l2;
            }
        }).build(this::getPublicKeyFromMauth);
    }

    private PublicKeyData getPublicKeyFromMauth(UUID uUID) {
        byte[] byArray = new byte[]{};
        String string = this.getRequestUrlPath(uUID);
        Map map = this.signer.generateRequestHeaders("GET", string, byArray, "");
        String string2 = this.configuration.getBaseUrl() + string;
        return this.get(string2, map, this.publicKeyResponseHandler);
    }

    public PublicKey getPublicKey(UUID uUID) {
        return ((PublicKeyData)this.publicKeyCache.get((Object)uUID)).getPublicKey();
    }

    private String getRequestUrlPath(UUID uUID) {
        return this.configuration.getRequestUrlPath() + String.format(this.configuration.getSecurityTokensUrlPath(), uUID.toString());
    }

    private <T> T get(String string, Map<String, String> map, ResponseHandler<T> responseHandler) {
        try {
            HttpGet httpGet = new HttpGet(string);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
            return (T)this.httpclient.execute((HttpUriRequest)httpGet, responseHandler);
        }
        catch (IOException iOException) {
            logger.error("Public key retrieval error", (Throwable)iOException);
            throw new HttpClientPublicKeyProviderException((Throwable)iOException);
        }
    }

    private static class PublicKeyData {
        private final PublicKey publicKey;
        private final Long maxAgeSeconds;

        public PublicKeyData(PublicKey publicKey, Long l) {
            this.publicKey = publicKey;
            this.maxAgeSeconds = l;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public Long getMaxAgeSeconds() {
            return this.maxAgeSeconds;
        }
    }

    private class PublicKeyResponseHandler
    implements ResponseHandler<PublicKeyData> {
        private static final String MAX_AGE = "max-age";
        private static final String PUBLIC_KEY_STR = "public_key_str";

        private PublicKeyResponseHandler() {
        }

        public PublicKeyData handleResponse(HttpResponse httpResponse) throws IOException {
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                Long l = this.getMaxAge(httpResponse).orElse(HttpClientPublicKeyProvider.this.configuration.getTimeToLive());
                HttpEntity httpEntity = httpResponse.getEntity();
                String string = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
                ObjectMapper objectMapper = new ObjectMapper();
                String string2 = objectMapper.readTree(string).findValue(PUBLIC_KEY_STR).asText();
                return new PublicKeyData(MAuthKeysHelper.getPublicKeyFromString((String)string2), l);
            }
            throw new HttpClientPublicKeyProviderException("Invalid response code returned by server: " + httpResponse.getStatusLine().getStatusCode());
        }

        public Optional<Long> getMaxAge(HttpResponse httpResponse) {
            return Optional.ofNullable(httpResponse.getHeaders("Cache-Control")).flatMap(headerArray -> Arrays.stream(headerArray).flatMap(header -> Arrays.stream(header.getElements()).filter(headerElement -> headerElement.getName().equalsIgnoreCase(MAX_AGE)).map(headerElement -> Long.parseLong(headerElement.getValue()))).findFirst());
        }
    }
}

