/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.holders;

import com.mchange.v2.holders.ThreadSafeIntHolder;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ChangeNotifyingSynchronizedIntHolder
implements ThreadSafeIntHolder,
Serializable {
    transient int value;
    transient boolean notify_all;
    static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    public ChangeNotifyingSynchronizedIntHolder(int value, boolean notify_all) {
        this.value = value;
        this.notify_all = notify_all;
    }

    public ChangeNotifyingSynchronizedIntHolder() {
        this(0, true);
    }

    @Override
    public synchronized int getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(int value) {
        if (value != this.value) {
            this.value = value;
            this.doNotify();
        }
    }

    public synchronized void increment() {
        ++this.value;
        this.doNotify();
    }

    public synchronized void decrement() {
        --this.value;
        this.doNotify();
    }

    private void doNotify() {
        if (this.notify_all) {
            this.notifyAll();
        } else {
            this.notify();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeInt(this.value);
        out.writeBoolean(this.notify_all);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        short version = in.readShort();
        switch (version) {
            case 1: {
                this.value = in.readInt();
                this.notify_all = in.readBoolean();
                break;
            }
            default: {
                throw new UnsupportedVersionException(this, version);
            }
        }
    }
}

