/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.xml;

import com.mchange.v1.util.DebugUtils;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DomParseUtils {
    static final boolean DEBUG = true;

    public static String allTextFromUniqueChild(Element elem, String childTagName) throws DOMException {
        return DomParseUtils.allTextFromUniqueChild(elem, childTagName, false);
    }

    public static String allTextFromUniqueChild(Element elem, String childTagName, boolean trim) throws DOMException {
        Element uniqueChild = DomParseUtils.uniqueChildByTagName(elem, childTagName);
        if (uniqueChild == null) {
            return null;
        }
        return DomParseUtils.allTextFromElement(uniqueChild, trim);
    }

    public static Element uniqueChild(Element elem, String childTagName) throws DOMException {
        return DomParseUtils.uniqueChildByTagName(elem, childTagName);
    }

    public static Element uniqueChildByTagName(Element elem, String childTagName) throws DOMException {
        NodeList nl = elem.getElementsByTagName(childTagName);
        int len = nl.getLength();
        DebugUtils.myAssert(len <= 1, "There is more than one (" + len + ") child with tag name: " + childTagName + "!!!");
        return len == 1 ? (Element)nl.item(0) : null;
    }

    public static String allText(Element elem) throws DOMException {
        return DomParseUtils.allTextFromElement(elem);
    }

    public static String allText(Element elem, boolean trim) throws DOMException {
        return DomParseUtils.allTextFromElement(elem, trim);
    }

    public static String allTextFromElement(Element elem) throws DOMException {
        return DomParseUtils.allTextFromElement(elem, false);
    }

    public static String allTextFromElement(Element elem, boolean trim) throws DOMException {
        StringBuffer textBuf = new StringBuffer();
        NodeList nl = elem.getChildNodes();
        int len = nl.getLength();
        for (int j = 0; j < len; ++j) {
            Node node = nl.item(j);
            if (!(node instanceof Text)) continue;
            textBuf.append(node.getNodeValue());
        }
        String out = textBuf.toString();
        return trim ? out.trim() : out;
    }

    public static String[] allTextFromImmediateChildElements(Element parent, String tagName) throws DOMException {
        return DomParseUtils.allTextFromImmediateChildElements(parent, tagName, false);
    }

    public static String[] allTextFromImmediateChildElements(Element parent, String tagName, boolean trim) throws DOMException {
        NodeList nl = DomParseUtils.immediateChildElementsByTagName(parent, tagName);
        int len = nl.getLength();
        String[] out = new String[len];
        for (int i = 0; i < len; ++i) {
            out[i] = DomParseUtils.allText((Element)nl.item(i), trim);
        }
        return out;
    }

    public static NodeList immediateChildElementsByTagName(Element parent, String tagName) throws DOMException {
        return DomParseUtils.getImmediateChildElementsByTagName(parent, tagName);
    }

    public static NodeList getImmediateChildElementsByTagName(Element parent, String tagName) throws DOMException {
        final ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !((Element)child).getTagName().equals(tagName)) continue;
            nodes.add(child);
        }
        return new NodeList(){

            @Override
            public int getLength() {
                return nodes.size();
            }

            @Override
            public Node item(int i) {
                return (Node)nodes.get(i);
            }
        };
    }

    public static String allTextFromUniqueImmediateChild(Element elem, String childTagName) throws DOMException {
        Element uniqueChild = DomParseUtils.uniqueImmediateChildByTagName(elem, childTagName);
        if (uniqueChild == null) {
            return null;
        }
        return DomParseUtils.allTextFromElement(uniqueChild);
    }

    public static Element uniqueImmediateChild(Element elem, String childTagName) throws DOMException {
        return DomParseUtils.uniqueImmediateChildByTagName(elem, childTagName);
    }

    public static Element uniqueImmediateChildByTagName(Element elem, String childTagName) throws DOMException {
        NodeList nl = DomParseUtils.getImmediateChildElementsByTagName(elem, childTagName);
        int len = nl.getLength();
        DebugUtils.myAssert(len <= 1, "There is more than one (" + len + ") child with tag name: " + childTagName + "!!!");
        return len == 1 ? (Element)nl.item(0) : null;
    }

    public static String attrValFromElement(Element element, String attrName) throws DOMException {
        Attr attr = element.getAttributeNode(attrName);
        return attr == null ? null : attr.getValue();
    }

    private DomParseUtils() {
    }
}

