/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.db.sql;

import com.mchange.v1.db.sql.ConnectionBundle;
import com.mchange.v1.db.sql.ConnectionBundleImpl;
import com.mchange.v1.db.sql.ConnectionBundlePool;
import com.mchange.v1.util.AbstractResourcePool;
import com.mchange.v1.util.BrokenObjectException;
import com.mchange.v1.util.UnexpectedException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class ConnectionBundlePoolImpl
extends AbstractResourcePool
implements ConnectionBundlePool {
    String jdbcUrl;
    String username;
    String pwd;

    public ConnectionBundlePoolImpl(String jdbcUrl, String username, String pwd, int start, int max, int inc) throws SQLException {
        super(start, max, inc);
        this.init(jdbcUrl, username, pwd);
    }

    protected ConnectionBundlePoolImpl(int start, int max, int inc) {
        super(start, max, inc);
    }

    protected void init(String jdbcUrl, String username, String pwd) throws SQLException {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.pwd = pwd;
        try {
            this.init();
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new UnexpectedException(e, "Unexpected exception while initializing ConnectionBundlePool");
        }
    }

    @Override
    public ConnectionBundle checkoutBundle() throws SQLException, BrokenObjectException, InterruptedException {
        try {
            return (ConnectionBundle)this.checkoutResource();
        }
        catch (BrokenObjectException boe) {
            throw boe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new UnexpectedException(e, "Unexpected exception while checking out ConnectionBundle");
        }
    }

    @Override
    public void checkinBundle(ConnectionBundle bndl) throws BrokenObjectException {
        this.checkinResource(bndl);
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedException(e, "Unexpected exception while closing pool.");
        }
    }

    @Override
    protected Object acquireResource() throws Exception {
        Connection con = DriverManager.getConnection(this.jdbcUrl, this.username, this.pwd);
        this.setConnectionOptions(con);
        return new ConnectionBundleImpl(con);
    }

    @Override
    protected void refurbishResource(Object resc) throws BrokenObjectException {
        boolean bad;
        try {
            Connection con = ((ConnectionBundle)resc).getConnection();
            con.rollback();
            bad = con.isClosed();
            this.setConnectionOptions(con);
        }
        catch (SQLException e) {
            bad = true;
        }
        if (bad) {
            throw new BrokenObjectException(resc);
        }
    }

    @Override
    protected void destroyResource(Object resc) throws Exception {
        ((ConnectionBundle)resc).close();
    }

    protected abstract void setConnectionOptions(Connection var1) throws SQLException;
}

