/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.cachedstore;

import com.mchange.v1.cachedstore.CachedStore;
import com.mchange.v1.cachedstore.CachedStoreException;
import com.mchange.v1.cachedstore.NoCleanupCachedStore;
import com.mchange.v1.util.WrapperIterator;
import java.util.Iterator;

abstract class KeyTransformingCachedStore
extends NoCleanupCachedStore {
    protected KeyTransformingCachedStore(CachedStore.Manager manager) {
        super(manager);
    }

    @Override
    public Object getCachedValue(Object key) {
        return this.cache.get(this.toCacheFetchKey(key));
    }

    @Override
    public void removeFromCache(Object key) throws CachedStoreException {
        this.cache.remove(this.toCacheFetchKey(key));
    }

    @Override
    public void setCachedValue(Object key, Object value) throws CachedStoreException {
        Object newKey = this.toCachePutKey(key);
        this.cache.put(newKey, value);
    }

    @Override
    public Iterator cachedKeys() throws CachedStoreException {
        return new WrapperIterator(this.cache.keySet().iterator(), false){

            @Override
            public Object transformObject(Object o) {
                Object out = KeyTransformingCachedStore.this.toUserKey(o);
                return out == null ? SKIP_TOKEN : out;
            }
        };
    }

    protected Object toUserKey(Object cachePutKey) {
        return cachePutKey;
    }

    protected Object toCacheFetchKey(Object userKey) {
        return this.toCachePutKey(userKey);
    }

    protected Object toCachePutKey(Object userKey) {
        return userKey;
    }

    protected Object removeByTransformedKey(Object cacheFetchKey) {
        return this.cache.remove(cacheFetchKey);
    }
}

