/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.CacheKey;
import com.maxmind.db.CachedConstructor;
import com.maxmind.db.ConstructorNotFoundException;
import com.maxmind.db.CtrlData;
import com.maxmind.db.DecodedValue;
import com.maxmind.db.DeserializationException;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.NodeCache;
import com.maxmind.db.ParameterNotFoundException;
import com.maxmind.db.Type;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class Decoder {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int[] POINTER_VALUE_OFFSETS = new int[]{0, 0, 2048, 526336, 0};
    boolean pointerTestHack = false;
    private final NodeCache cache;
    private final long pointerBase;
    private final CharsetDecoder utfDecoder = UTF_8.newDecoder();
    private final ByteBuffer buffer;
    private final ConcurrentHashMap<Class, CachedConstructor> constructors;
    private final NodeCache.Loader cacheLoader = this::decode;

    Decoder(NodeCache cache, ByteBuffer buffer, long pointerBase) {
        this(cache, buffer, pointerBase, new ConcurrentHashMap<Class, CachedConstructor>());
    }

    Decoder(NodeCache cache, ByteBuffer buffer, long pointerBase, ConcurrentHashMap<Class, CachedConstructor> constructors) {
        this.cache = cache;
        this.pointerBase = pointerBase;
        this.buffer = buffer;
        this.constructors = constructors;
    }

    public <T> T decode(int offset, Class<T> cls) throws IOException {
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        return cls.cast(this.decode(cls, null).getValue());
    }

    private <T> DecodedValue decode(CacheKey<T> key) throws IOException {
        int offset = key.getOffset();
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        Class<T> cls = key.getCls();
        return this.decode(cls, key.getType());
    }

    private <T> DecodedValue decode(Class<T> cls, java.lang.reflect.Type genericType) throws IOException {
        int size;
        int ctrlByte = 0xFF & this.buffer.get();
        Type type = Type.fromControlByte(ctrlByte);
        if (type.equals((Object)Type.POINTER)) {
            int pointerSize = (ctrlByte >>> 3 & 3) + 1;
            int base = (byte)(pointerSize == 4 ? 0 : (byte)(ctrlByte & 7));
            int packed = this.decodeInteger(base, pointerSize);
            long pointer = (long)packed + this.pointerBase + (long)POINTER_VALUE_OFFSETS[pointerSize];
            if (this.pointerTestHack) {
                return new DecodedValue(pointer);
            }
            int targetOffset = (int)pointer;
            int position = this.buffer.position();
            CacheKey<T> key = new CacheKey<T>(targetOffset, cls, genericType);
            DecodedValue o = this.cache.get(key, this.cacheLoader);
            this.buffer.position(position);
            return o;
        }
        if (type.equals((Object)Type.EXTENDED)) {
            byte nextByte = this.buffer.get();
            int typeNum = nextByte + 7;
            if (typeNum < 8) {
                throw new InvalidDatabaseException("Something went horribly wrong in the decoder. An extended type resolved to a type number < 8 (" + typeNum + ")");
            }
            type = Type.get(typeNum);
        }
        if ((size = ctrlByte & 0x1F) >= 29) {
            switch (size) {
                case 29: {
                    size = 29 + (0xFF & this.buffer.get());
                    break;
                }
                case 30: {
                    size = 285 + this.decodeInteger(2);
                    break;
                }
                default: {
                    size = 65821 + this.decodeInteger(3);
                }
            }
        }
        return new DecodedValue(this.decodeByType(type, size, cls, genericType));
    }

    private <T> Object decodeByType(Type type, int size, Class<T> cls, java.lang.reflect.Type genericType) throws IOException {
        switch (type) {
            case MAP: {
                return this.decodeMap(size, cls, genericType);
            }
            case ARRAY: {
                ParameterizedType ptype;
                java.lang.reflect.Type[] actualTypes;
                Class elementClass = Object.class;
                if (genericType instanceof ParameterizedType && (actualTypes = (ptype = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
                    elementClass = (Class)actualTypes[0];
                }
                return this.decodeArray(size, cls, elementClass);
            }
            case BOOLEAN: {
                return Decoder.decodeBoolean(size);
            }
            case UTF8_STRING: {
                return this.decodeString(size);
            }
            case DOUBLE: {
                return this.decodeDouble(size);
            }
            case FLOAT: {
                return Float.valueOf(this.decodeFloat(size));
            }
            case BYTES: {
                return this.getByteArray(size);
            }
            case UINT16: {
                return this.decodeUint16(size);
            }
            case UINT32: {
                return this.decodeUint32(size);
            }
            case INT32: {
                return this.decodeInt32(size);
            }
            case UINT64: 
            case UINT128: {
                return this.decodeBigInteger(size);
            }
        }
        throw new InvalidDatabaseException("Unknown or unexpected type: " + type.name());
    }

    private String decodeString(int size) throws CharacterCodingException {
        int oldLimit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + size);
        String s = this.utfDecoder.decode(this.buffer).toString();
        this.buffer.limit(oldLimit);
        return s;
    }

    private int decodeUint16(int size) {
        return this.decodeInteger(size);
    }

    private int decodeInt32(int size) {
        return this.decodeInteger(size);
    }

    private long decodeLong(int size) {
        long integer = 0L;
        for (int i = 0; i < size; ++i) {
            integer = integer << 8 | (long)(this.buffer.get() & 0xFF);
        }
        return integer;
    }

    private long decodeUint32(int size) {
        return this.decodeLong(size);
    }

    private int decodeInteger(int size) {
        return this.decodeInteger(0, size);
    }

    private int decodeInteger(int base, int size) {
        return Decoder.decodeInteger(this.buffer, base, size);
    }

    static int decodeInteger(ByteBuffer buffer, int base, int size) {
        int integer = base;
        for (int i = 0; i < size; ++i) {
            integer = integer << 8 | buffer.get() & 0xFF;
        }
        return integer;
    }

    private BigInteger decodeBigInteger(int size) {
        byte[] bytes = this.getByteArray(size);
        return new BigInteger(1, bytes);
    }

    private double decodeDouble(int size) throws InvalidDatabaseException {
        if (size != 8) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of double.");
        }
        return this.buffer.getDouble();
    }

    private float decodeFloat(int size) throws InvalidDatabaseException {
        if (size != 4) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of float.");
        }
        return this.buffer.getFloat();
    }

    private static boolean decodeBoolean(int size) throws InvalidDatabaseException {
        switch (size) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of boolean.");
    }

    private <T, V> List<V> decodeArray(int size, Class<T> cls, Class<V> elementClass) throws IOException {
        List<Object> array;
        if (!List.class.isAssignableFrom(cls) && !cls.equals(Object.class)) {
            throw new DeserializationException("Unable to deserialize an array into an " + cls);
        }
        if (cls.equals(List.class) || cls.equals(Object.class)) {
            array = new ArrayList<V>(size);
        } else {
            Constructor<T> constructor;
            try {
                constructor = cls.getConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new DeserializationException("No constructor found for the List: " + e.getMessage(), e);
            }
            Object[] parameters = new Object[]{size};
            try {
                List array2 = (List)constructor.newInstance(parameters);
                array = array2;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new DeserializationException("Error creating list: " + e.getMessage(), e);
            }
        }
        for (int i = 0; i < size; ++i) {
            Object e = this.decode(elementClass, null).getValue();
            array.add(elementClass.cast(e));
        }
        return array;
    }

    private <T> Object decodeMap(int size, Class<T> cls, java.lang.reflect.Type genericType) throws IOException {
        if (Map.class.isAssignableFrom(cls) || cls.equals(Object.class)) {
            ParameterizedType ptype;
            java.lang.reflect.Type[] actualTypes;
            Class valueClass = Object.class;
            if (genericType instanceof ParameterizedType && (actualTypes = (ptype = (ParameterizedType)genericType).getActualTypeArguments()).length == 2) {
                Class keyClass = (Class)actualTypes[0];
                if (!keyClass.equals(String.class)) {
                    throw new DeserializationException("Map keys must be strings.");
                }
                valueClass = (Class)actualTypes[1];
            }
            return this.decodeMapIntoMap(cls, size, valueClass);
        }
        return this.decodeMapIntoObject(size, cls);
    }

    private <T, V> Map<String, V> decodeMapIntoMap(Class<T> cls, int size, Class<V> valueClass) throws IOException {
        Map<String, V> map;
        if (cls.equals(Map.class) || cls.equals(Object.class)) {
            map = new HashMap<String, V>(size);
        } else {
            Constructor<T> constructor;
            try {
                constructor = cls.getConstructor(Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new DeserializationException("No constructor found for the Map: " + e.getMessage(), e);
            }
            Object[] parameters = new Object[]{size};
            try {
                Map map2 = (Map)constructor.newInstance(parameters);
                map = map2;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new DeserializationException("Error creating map: " + e.getMessage(), e);
            }
        }
        for (int i = 0; i < size; ++i) {
            String key = (String)this.decode(String.class, null).getValue();
            Object value = this.decode(valueClass, null).getValue();
            try {
                map.put(key, valueClass.cast(value));
                continue;
            }
            catch (ClassCastException e) {
                throw new DeserializationException("Error creating map entry for '" + key + "': " + e.getMessage(), e);
            }
        }
        return map;
    }

    private <T> Object decodeMapIntoObject(int size, Class<T> cls) throws IOException {
        int i;
        Map<String, Integer> parameterIndexes;
        java.lang.reflect.Type[] parameterGenericTypes;
        Class<?>[] parameterTypes;
        Constructor<T> constructor;
        CachedConstructor cachedConstructor = this.constructors.get(cls);
        if (cachedConstructor == null) {
            constructor = Decoder.findConstructor(cls);
            parameterTypes = constructor.getParameterTypes();
            parameterGenericTypes = constructor.getGenericParameterTypes();
            parameterIndexes = new HashMap<String, Integer>();
            Annotation[][] annotations = constructor.getParameterAnnotations();
            for (i = 0; i < constructor.getParameterCount(); ++i) {
                String parameterName = Decoder.getParameterName(cls, i, annotations[i]);
                parameterIndexes.put(parameterName, i);
            }
            this.constructors.put(cls, new CachedConstructor<T>(constructor, parameterTypes, parameterGenericTypes, parameterIndexes));
        } else {
            constructor = cachedConstructor.getConstructor();
            parameterTypes = cachedConstructor.getParameterTypes();
            parameterGenericTypes = cachedConstructor.getParameterGenericTypes();
            parameterIndexes = cachedConstructor.getParameterIndexes();
        }
        Object[] parameters = new Object[parameterTypes.length];
        for (i = 0; i < size; ++i) {
            String key = (String)this.decode(String.class, null).getValue();
            Integer parameterIndex = parameterIndexes.get(key);
            if (parameterIndex == null) {
                int offset = this.nextValueOffset(this.buffer.position(), 1);
                this.buffer.position(offset);
                continue;
            }
            parameters[parameterIndex.intValue()] = this.decode(parameterTypes[parameterIndex], parameterGenericTypes[parameterIndex]).getValue();
        }
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DeserializationException("Error creating object: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sbErrors = new StringBuilder();
            for (String key : parameterIndexes.keySet()) {
                int index = parameterIndexes.get(key);
                if (parameters[index] == null || parameters[index].getClass().isAssignableFrom(parameterTypes[index])) continue;
                sbErrors.append(" argument type mismatch in " + key + " MMDB Type: " + parameters[index].getClass().getCanonicalName() + " Java Type: " + parameterTypes[index].getCanonicalName());
            }
            throw new DeserializationException("Error creating object of type: " + cls.getSimpleName() + " - " + sbErrors, e);
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> cls) throws ConstructorNotFoundException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (constructor.getAnnotation(MaxMindDbConstructor.class) == null) continue;
            Constructor<?> constructor2 = constructor;
            return constructor2;
        }
        throw new ConstructorNotFoundException("No constructor on class " + cls.getName() + " with the MaxMindDbConstructor annotation was found.");
    }

    private static <T> String getParameterName(Class<T> cls, int index, Annotation[] annotations) throws ParameterNotFoundException {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(MaxMindDbParameter.class)) continue;
            MaxMindDbParameter paramAnnotation = (MaxMindDbParameter)annotation;
            return paramAnnotation.name();
        }
        throw new ParameterNotFoundException("Constructor parameter " + index + " on class " + cls.getName() + " is not annotated with MaxMindDbParameter.");
    }

    private int nextValueOffset(int offset, int numberToSkip) throws InvalidDatabaseException {
        if (numberToSkip == 0) {
            return offset;
        }
        CtrlData ctrlData = this.getCtrlData(offset);
        int ctrlByte = ctrlData.getCtrlByte();
        int size = ctrlData.getSize();
        offset = ctrlData.getOffset();
        Type type = ctrlData.getType();
        switch (type) {
            case POINTER: {
                int pointerSize = (ctrlByte >>> 3 & 3) + 1;
                offset += pointerSize;
                break;
            }
            case MAP: {
                numberToSkip += 2 * size;
                break;
            }
            case ARRAY: {
                numberToSkip += size;
                break;
            }
            case BOOLEAN: {
                break;
            }
            default: {
                offset += size;
            }
        }
        return this.nextValueOffset(offset, numberToSkip - 1);
    }

    private CtrlData getCtrlData(int offset) throws InvalidDatabaseException {
        int size;
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        int ctrlByte = 0xFF & this.buffer.get();
        ++offset;
        Type type = Type.fromControlByte(ctrlByte);
        if (type.equals((Object)Type.EXTENDED)) {
            byte nextByte = this.buffer.get();
            int typeNum = nextByte + 7;
            if (typeNum < 8) {
                throw new InvalidDatabaseException("Something went horribly wrong in the decoder. An extended type resolved to a type number < 8 (" + typeNum + ")");
            }
            type = Type.get(typeNum);
            ++offset;
        }
        if ((size = ctrlByte & 0x1F) >= 29) {
            int bytesToRead = size - 28;
            offset += bytesToRead;
            switch (size) {
                case 29: {
                    size = 29 + (0xFF & this.buffer.get());
                    break;
                }
                case 30: {
                    size = 285 + this.decodeInteger(2);
                    break;
                }
                default: {
                    size = 65821 + this.decodeInteger(3);
                }
            }
        }
        return new CtrlData(type, ctrlByte, offset, size);
    }

    private byte[] getByteArray(int length) {
        return Decoder.getByteArray(this.buffer, length);
    }

    private static byte[] getByteArray(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }
}

