/*
 * Decompiled with CFR 0.152.
 */
package master.library;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import master.library.R;

public class CommonUtils {
    private static ArrayList<Object> list;
    private static Gson gson;
    public static int DEVICE_WIDTH;
    public static int DEVICE_HEIGHT;

    public static void makeClearableEditText(final EditText editText, final int res, String defaultValue, final View.OnClickListener clickListener) {
        final String defaultText = defaultValue == null ? editText.getText().toString().trim() : defaultValue;
        final View.OnTouchListener onTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean DRAWABLE_LEFT = false;
                boolean DRAWABLE_TOP = true;
                int DRAWABLE_RIGHT = 2;
                int DRAWABLE_BOTTOM = 3;
                if (event.getAction() == 1 && event.getRawX() >= (float)(editText.getRight() - editText.getCompoundDrawables()[2].getBounds().width())) {
                    editText.setOnTouchListener(null);
                    editText.setText((CharSequence)defaultText);
                    clickListener.onClick((View)editText);
                    return true;
                }
                return false;
            }
        };
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (TextUtils.isEmpty((CharSequence)editText.getText().toString().trim()) || defaultText.equalsIgnoreCase(editText.getText().toString().trim())) {
                    editText.setCompoundDrawablesWithIntrinsicBounds(editText.getCompoundDrawables()[0], editText.getCompoundDrawables()[1], editText.getCompoundDrawables()[2], editText.getCompoundDrawables()[3]);
                    editText.setOnTouchListener(null);
                } else {
                    editText.setCompoundDrawablesWithIntrinsicBounds(editText.getCompoundDrawables()[0], editText.getCompoundDrawables()[1], ContextCompat.getDrawable((Context)editText.getContext(), (int)res), editText.getCompoundDrawables()[3]);
                    editText.setOnTouchListener(onTouchListener);
                }
            }
        });
    }

    public static void saveInPref(Context context, Object user) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(context.getString(R.string.app_name), 0);
        sharedPreferences.edit().putString(user.getClass().getSimpleName(), CommonUtils.getJsonStringFromObject(user)).commit();
        int i = 0;
        if (list != null) {
            boolean isFound = false;
            for (Object object : list) {
                if (object.getClass() == user.getClass()) {
                    list.set(i, user);
                    isFound = true;
                    break;
                }
                ++i;
            }
            if (!isFound) {
                list.add(user);
            }
        }
    }

    public static Object getFromPref(Context context, Class myClass) {
        SharedPreferences sharedPreferences;
        String data;
        if (list != null) {
            for (Object object : list) {
                if (object.getClass() != myClass) continue;
                return object;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(data = (sharedPreferences = context.getSharedPreferences(context.getString(R.string.app_name), 0)).getString(myClass.getSimpleName(), "")))) {
            return CommonUtils.getObjectFromJsonString(data, myClass);
        }
        return null;
    }

    public static <T> Object getObjectFromJsonString(String jsonData, Class modelClass) {
        return gson.fromJson(jsonData, modelClass);
    }

    public static String getJsonStringFromObject(Object modelClass) {
        return gson.toJson(modelClass);
    }

    public static <T> String getJsonStringFromObject(List<T> objectArrayList) {
        return gson.toJson(objectArrayList, new TypeToken<List<T>>(){}.getType());
    }

    public static <T> ArrayList<T> getObjectListFromJsonString(String jsonData, Class myclass) {
        return new ArrayList<Object>(Arrays.asList((Object[])gson.fromJson(jsonData, myclass)));
    }

    public static int[] getDeviceWidthHeight(Activity activity) {
        int[] size = new int[2];
        if (Build.VERSION.SDK_INT >= 14) {
            DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
            size[0] = displayMetrics.widthPixels;
            size[1] = displayMetrics.heightPixels;
            DEVICE_WIDTH = size[0];
            DEVICE_HEIGHT = size[1];
        } else {
            Display mDisplay = activity.getWindowManager().getDefaultDisplay();
            size[0] = mDisplay.getWidth();
            size[1] = mDisplay.getHeight();
            DEVICE_WIDTH = size[0];
            DEVICE_HEIGHT = size[1];
        }
        return size;
    }

    static {
        gson = new GsonBuilder().create();
    }
}

