package master.library;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;

/**
 * Created by pankaj on 10/4/17.
 */

public class DialogUtils {
    private DialogUtils() {
    }

    static ProgressDialog progressDialog;

    public static void showProgressDialog(Context context, int message) {

        try {
            progressDialog = DialogUtils.showProgressDialog(context, context.getString(message));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void hideProgressDialog() {
        try {
            if (progressDialog != null) {
                progressDialog.dismiss();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ProgressDialog showProgressDialog(Context context, String message) {
        try {
            progressDialog = new ProgressDialog(context);
            progressDialog.setMessage(message);
            progressDialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return progressDialog;
    }

    public static AlertDialog showAlert(Context context, int title, int message,
                                        int positiveButton, DialogInterface.OnClickListener positiveButtonClickListener,
                                        int negativeButton, DialogInterface.OnClickListener negativeButtonClickListener
    ) {
        return DialogUtils.showAlert(context, title, message, positiveButton, positiveButtonClickListener, negativeButton, negativeButtonClickListener, 0, null, null, false, null, null);
    }

    public static AlertDialog showAlert(Context context, int title, int message,
                                        int positiveButton, DialogInterface.OnClickListener positiveButtonClickListener,
                                        int negativeButton, DialogInterface.OnClickListener negativeButtonClickListener,
                                        int neutralButton, DialogInterface.OnClickListener neutralButtonClickListener,
                                        DialogInterface.OnShowListener onShowListener,
                                        boolean cancelable,
                                        DialogInterface.OnCancelListener onCancelListener,
                                        DialogInterface.OnDismissListener onDismissListener) {
        AlertDialog.Builder promptBuilder = new AlertDialog.Builder(context);
        if (title != 0) {
            promptBuilder.setTitle(title);
        }
        if (message != 0) {
            promptBuilder.setMessage(message);
        }
        if (positiveButton != 0) {
            promptBuilder.setPositiveButton(positiveButton,
                    positiveButtonClickListener);
        }
        if (negativeButton != 0) {
            promptBuilder.setNegativeButton(negativeButton,
                    negativeButtonClickListener);
        }
        if (neutralButton != 0) {
            promptBuilder.setNeutralButton(neutralButton,
                    neutralButtonClickListener);
        }

        promptBuilder.setCancelable(true);
        if (cancelable) {
            promptBuilder.setOnCancelListener(onCancelListener);
        }
        AlertDialog alertDialog = promptBuilder.create();
        if (!(context instanceof Activity)) {
            alertDialog.getWindow()
                    .setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
        }
        alertDialog.setOnDismissListener(onDismissListener);
        alertDialog.setOnShowListener(onShowListener);
        alertDialog.show();
        return alertDialog;
    }

    public static AlertDialog showAlert(Context context, String title, String message, String[] list, DialogInterface.OnClickListener onClickListener) {
        AlertDialog.Builder promptBuilder = new AlertDialog.Builder(context);
        if (title != null) {
            promptBuilder.setTitle(title);
        }
        if (message != null) {
            promptBuilder.setMessage(message);
        }
        promptBuilder.setItems(list, onClickListener);
        promptBuilder.setCancelable(true);
        AlertDialog alertDialog = promptBuilder.create();
        if (!(context instanceof Activity)) {
            alertDialog.getWindow()
                    .setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
        }
        alertDialog.show();
        return alertDialog;
    }

    public static AlertDialog showAlert(Context context, String title, String message, String confirmButton, DialogInterface.OnClickListener confirmButtonClickListener, String centerButton, DialogInterface.OnClickListener centerButtonClickListener, String cancelButton, DialogInterface.OnClickListener cancelButtonClickListener, DialogInterface.OnShowListener onShowListener, boolean cancelable, DialogInterface.OnCancelListener onCancelListener, DialogInterface.OnDismissListener onDismissListener) {
        AlertDialog.Builder promptBuilder = new AlertDialog.Builder(context);
        if (title != null) {
            promptBuilder.setTitle(title);
        }
        if (message != null) {
            promptBuilder.setMessage(message);
        }
        if (confirmButton != null) {
            promptBuilder.setPositiveButton(confirmButton,
                    confirmButtonClickListener);
        }
        if (centerButton != null) {
            promptBuilder.setNeutralButton(centerButton,
                    centerButtonClickListener);
        }
        if (cancelButton != null) {
            promptBuilder.setNegativeButton(cancelButton,
                    cancelButtonClickListener);
        }
        promptBuilder.setCancelable(true);
        if (cancelable) {
            promptBuilder.setOnCancelListener(onCancelListener);
        }
        AlertDialog alertDialog = promptBuilder.create();
        if (!(context instanceof Activity)) {
            alertDialog.getWindow()
                    .setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
        }
        alertDialog.setOnDismissListener(onDismissListener);
        alertDialog.setOnShowListener(onShowListener);
        alertDialog.show();
        return alertDialog;
    }


    public static AlertDialog showAlert(Context context, String title, String message, String confirmButton, DialogInterface.OnClickListener confirmButtonClickListener, String cancelButton, DialogInterface.OnClickListener cancelButtonClickListener) {
        return showAlert(context, title, message, confirmButton,
                confirmButtonClickListener, null, null, cancelButton,
                cancelButtonClickListener, null, true, null, null);
    }


    public static AlertDialog showPrompt(Context context, String message, String confirmButton) {
        return showAlert(context, null, message, confirmButton, null, null,
                null, null, null, null, true, null, null);
    }


    public static AlertDialog showPrompt(Context context, String message) {
        return showAlert(context, context.getString(R.string.app_name), message, "OK", null, null, null, null,
                null, null, true, null, null);
    }

    public static AlertDialog showPrompt(Context context, int message) {
        return showAlert(context, context.getString(R.string.app_name), context.getString(message), "OK", null, null, null, null,
                null, null, true, null, null);
    }

    public static AlertDialog showListDialog(Context context, String[] list, DialogInterface.OnClickListener listener) {
        AlertDialog.Builder promptBuilder = new AlertDialog.Builder(context);
        promptBuilder.setItems(list, listener);
        promptBuilder.setPositiveButton("Close", null);
        AlertDialog alertDialog = promptBuilder.create();
        if (!(context instanceof Activity)) {
            alertDialog.getWindow()
                    .setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
        }
        alertDialog.show();
        return alertDialog;
    }
}
