/*
 * Decompiled with CFR 0.152.
 */
package master.library;

import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;

public abstract class LazyTextWatcher
implements TextWatcher {
    public static int DELAY_TIME = 300;
    boolean isTypingStarts = false;
    Handler handler = new Handler();
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (LazyTextWatcher.this.isTypingStarts) {
                LazyTextWatcher.this.isTypingStarts = false;
                LazyTextWatcher.this.onTypingStop();
            }
        }
    };

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isTypingStarts) {
            this.handler.removeCallbacks(this.runnable);
            this.handler.postDelayed(this.runnable, (long)DELAY_TIME);
        } else if (s.toString().length() > 0) {
            this.isTypingStarts = true;
            this.handler.postDelayed(this.runnable, (long)DELAY_TIME);
            this.onTypingStart();
        }
    }

    public void onTypingStart() {
    }

    public void onTypingStop() {
    }

    public void onTextChanged(CharSequence s) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }
}

