/*
 * Decompiled with CFR 0.152.
 */
package master.library;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.CheckResult;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;

public final class FragmentUtils {
    private FragmentUtils() {
        throw new RuntimeException("Unable to instantiate class " + this.getClass().getCanonicalName());
    }

    public static void replace(AppCompatActivity activity, @IdRes int frameResId, Class clazz, @Nullable Bundle fragmentBundle, boolean addToBackStack, @Nullable String tag) {
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.replace(frameResId, Fragment.instantiate((Context)activity, (String)clazz.getName(), (Bundle)fragmentBundle), tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.setTransition(4097);
        ft.commitAllowingStateLoss();
    }

    public static void replace(AppCompatActivity activity, @IdRes int frameResId, Fragment fragment, boolean addToBackStack, @Nullable String tag) {
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.replace(frameResId, fragment, tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.setTransition(4097);
        ft.commitAllowingStateLoss();
    }

    public static void replaceWithAnim(AppCompatActivity activity, @IdRes int frameResId, Fragment fragment, boolean addToBackStack, @Nullable String tag, @AnimRes int animIn, @AnimRes int animOut) {
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.setCustomAnimations(animIn, animOut);
        ft.replace(frameResId, fragment, tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.commitAllowingStateLoss();
    }

    public static void add(AppCompatActivity activity, @IdRes int frameResId, Class clazz, @Nullable Bundle bundle, boolean addToBackStack, @Nullable String tag) {
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.add(frameResId, Fragment.instantiate((Context)activity, (String)clazz.getName(), (Bundle)bundle), tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.setTransition(4097);
        ft.commitAllowingStateLoss();
    }

    public static void add(AppCompatActivity activity, @IdRes int frameResId, Fragment fragment, boolean addToBackStack, @Nullable String tag) {
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.add(frameResId, fragment, tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.setTransition(4097);
        ft.commitAllowingStateLoss();
    }

    public static void add(AppCompatActivity activity, @IdRes int frameResId, Fragment fragment, boolean addToBackStack) {
        FragmentUtils.add(activity, frameResId, fragment, addToBackStack, null);
    }

    public static void add(AppCompatActivity activity, @IdRes int frameResId, Fragment fragment) {
        FragmentUtils.add(activity, frameResId, fragment, false, null);
    }

    public static void add(AppCompatActivity activity, @IdRes int frameResId, Fragment fragment, @Nullable String tag) {
        FragmentUtils.add(activity, frameResId, fragment, false, tag);
    }

    public static void add(AppCompatActivity activity, Fragment fragment, @Nullable String tag) {
        FragmentUtils.add(activity, 0, fragment, false, tag);
    }

    public static void pop(AppCompatActivity activity) {
        activity.getSupportFragmentManager().popBackStack();
    }

    public static void addChild(Fragment rootFragment, @IdRes int frameResId, Fragment fragment, boolean addToBackStack, @Nullable String tag) {
        FragmentTransaction ft = rootFragment.getChildFragmentManager().beginTransaction();
        ft.add(frameResId, fragment, tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.setTransition(4097);
        ft.commitAllowingStateLoss();
    }

    public static void replaceChild(Fragment rootFragment, @IdRes int frameResId, Fragment fragment, boolean addToBackStack, @Nullable String tag) {
        FragmentTransaction ft = rootFragment.getChildFragmentManager().beginTransaction();
        ft.replace(frameResId, fragment, tag);
        if (addToBackStack) {
            ft.addToBackStack(null);
        }
        ft.setTransition(4097);
        ft.commitAllowingStateLoss();
    }

    @CheckResult
    @Nullable
    public static <T extends Fragment> T findChildByTag(Fragment fragment, @NonNull String tag) {
        return (T)fragment.getChildFragmentManager().findFragmentByTag(tag);
    }

    public static void addChild(Fragment rootFragment, @IdRes int frameResId, Fragment fragment, @Nullable String tag) {
        FragmentUtils.addChild(rootFragment, frameResId, fragment, false, tag);
    }

    @CheckResult
    @Nullable
    public static <T extends Fragment> T findByTag(AppCompatActivity activity, @NonNull String tag) {
        return (T)activity.getSupportFragmentManager().findFragmentByTag(tag);
    }

    @CheckResult
    @Nullable
    public static <T extends Fragment> T findById(AppCompatActivity activity, @IdRes int id) {
        return (T)activity.getSupportFragmentManager().findFragmentById(id);
    }

    public static void showDialog(AppCompatActivity activity, DialogFragment dialogFragment, @Nullable String tag) {
        dialogFragment.show(activity.getSupportFragmentManager(), tag);
    }

    public static void showDialog(AppCompatActivity activity, DialogFragment dialogFragment) {
        FragmentUtils.showDialog(activity, dialogFragment, null);
    }

    public static boolean removeByTag(AppCompatActivity activity, @NonNull String tag) {
        Object fr = FragmentUtils.findByTag(activity, tag);
        if (null != fr) {
            activity.getSupportFragmentManager().beginTransaction().remove(fr).commit();
            return true;
        }
        return false;
    }

    public static boolean removeById(AppCompatActivity activity, @IdRes int id) {
        Object fr = FragmentUtils.findById(activity, id);
        if (null != fr) {
            activity.getSupportFragmentManager().beginTransaction().remove(fr).commit();
            return true;
        }
        return false;
    }

    public static void show(AppCompatActivity activity, Fragment fragment) {
        activity.getSupportFragmentManager().beginTransaction().show(fragment).commit();
    }

    public static void hide(AppCompatActivity activity, Fragment fragment) {
        activity.getSupportFragmentManager().beginTransaction().hide(fragment).commit();
    }

    public static void hideAndShow(AppCompatActivity activity, Fragment hide, Fragment show) {
        activity.getSupportFragmentManager().beginTransaction().hide(hide).show(show).commit();
    }

    public static void hideAndShowWithAnimation(AppCompatActivity activity, Fragment hide, Fragment show, @AnimRes int animIn, @AnimRes int animOut) {
        activity.getSupportFragmentManager().beginTransaction().setCustomAnimations(animIn, animOut).hide(hide).show(show).commit();
    }
}

