/*
 * Decompiled with CFR 0.152.
 */
package master.library;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;

public class DeviceUtils {
    public static void hideKeyboard(Activity activity) {
        if (activity != null) {
            InputMethodManager inputManager = (InputMethodManager)activity.getSystemService("input_method");
            View view = activity.getCurrentFocus();
            if (view != null) {
                inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
            }
        }
    }

    public static void hideKeyboard(Activity activity, EditText edt) {
        if (activity != null) {
            InputMethodManager inputManager = (InputMethodManager)activity.getSystemService("input_method");
            if (edt != null) {
                inputManager.hideSoftInputFromWindow(edt.getWindowToken(), 2);
            }
        }
    }

    public static void showKeyboard(Activity activity, EditText edt) {
        if (activity != null) {
            InputMethodManager inputManager = (InputMethodManager)activity.getSystemService("input_method");
            if (edt != null) {
                edt.requestFocus();
                inputManager.showSoftInput((View)edt, 1);
            }
        }
    }

    public static final String getCurrencyCode() {
        return Currency.getInstance(Locale.getDefault()).getCurrencyCode();
    }

    public static final String getTimezoneOffset() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getDisplayName(false, 0);
    }

    public String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return this.capitalize(model);
        }
        return this.capitalize(manufacturer) + " " + model;
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public static String getDeviceId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getDeviceId();
    }

    public static String getSubscriberId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getSubscriberId();
    }

    public static String getDeviceUniqueId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId;
    }
}

