/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.util;

import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;
import java.util.Set;

public class DefaultDocumentPermissionsParser
implements DocumentPermissionsParser {
    @Override
    public void parsePermissions(String str, DocumentMetadataHandle.DocumentPermissions permissions) {
        if (str != null && str.trim().length() > 0) {
            String[] tokens = str.split(",");
            for (int i = 0; i < tokens.length; i += 2) {
                String role = tokens[i];
                if (i + 1 >= tokens.length) {
                    throw new IllegalArgumentException("Unable to parse permissions string, which must be a comma-separated list of role names and capabilities - i.e. role1,read,role2,update,role3,execute; string: " + str);
                }
                String capability = tokens[i + 1];
                DocumentMetadataHandle.Capability c = null;
                if (capability.equals("execute")) {
                    c = DocumentMetadataHandle.Capability.EXECUTE;
                } else if (capability.equals("insert")) {
                    c = DocumentMetadataHandle.Capability.INSERT;
                } else if (capability.equals("update")) {
                    c = DocumentMetadataHandle.Capability.UPDATE;
                } else if (capability.equals("read")) {
                    c = DocumentMetadataHandle.Capability.READ;
                }
                if (permissions.containsKey((Object)role)) {
                    ((Set)permissions.get((Object)role)).add(c);
                    continue;
                }
                permissions.add(role, new DocumentMetadataHandle.Capability[]{c});
            }
        }
    }
}

