/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.tokenreplacer;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.tokenreplacer.PropertiesSource;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.PropertyPlaceholderHelper;

public class DefaultTokenReplacer
extends LoggingObject
implements TokenReplacer {
    private Properties properties;
    private PropertyPlaceholderHelper helper;
    private List<PropertiesSource> propertiesSources = new ArrayList<PropertiesSource>();
    private String propertyPrefix;

    public void addPropertiesSource(PropertiesSource source) {
        this.propertiesSources.add(source);
    }

    protected void initializeHelper() {
        this.helper = new PropertyPlaceholderHelper("${", "}", ":", true);
    }

    protected void initializeProperties() {
        this.properties = new Properties();
        for (PropertiesSource source : this.propertiesSources) {
            Properties p = source.getProperties();
            if (p == null) continue;
            this.properties.putAll((Map<?, ?>)p);
        }
    }

    @Override
    public String replaceTokens(String text) {
        if (this.properties == null) {
            this.initializeProperties();
        }
        if (this.helper == null) {
            this.initializeHelper();
        }
        for (Object key : this.properties.keySet()) {
            String skey;
            String string = skey = this.propertyPrefix != null ? this.propertyPrefix + key : key.toString();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Checking for key in text: " + skey);
            }
            if (!text.contains(skey)) continue;
            String value = this.properties.getProperty(key.toString());
            value = this.helper.replacePlaceholders(value, this.properties);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.format("Replacing %s with %s", skey, value));
            }
            text = text.replace(skey, value);
        }
        return text;
    }

    public List<PropertiesSource> getPropertiesSources() {
        return this.propertiesSources;
    }

    public void setPropertiesSources(List<PropertiesSource> propertiesSources) {
        this.propertiesSources = propertiesSources;
    }

    public void setPropertyPlaceholderHelper(PropertyPlaceholderHelper helper) {
        this.helper = helper;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }
}

