/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.schemasloader.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.batch.RestBatchWriter;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.GenericFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultFileFilter;
import com.marklogic.client.ext.schemasloader.SchemasLoader;
import com.marklogic.client.ext.schemasloader.impl.TdeDocumentFileProcessor;
import java.util.List;
import java.util.function.Supplier;

public class DefaultSchemasLoader
extends GenericFileLoader
implements SchemasLoader {
    private DatabaseClient schemasDatabaseClient;
    private String tdeValidationDatabase;

    public DefaultSchemasLoader(DatabaseClient schemasDatabaseClient) {
        this(schemasDatabaseClient, null);
    }

    public DefaultSchemasLoader(DatabaseClient schemasDatabaseClient, String tdeValidationDatabase) {
        super(((Supplier<BatchWriter>)() -> {
            RestBatchWriter writer = new RestBatchWriter(schemasDatabaseClient);
            writer.setThreadCount(1);
            writer.setReleaseDatabaseClients(false);
            return writer;
        }).get());
        this.schemasDatabaseClient = schemasDatabaseClient;
        this.tdeValidationDatabase = tdeValidationDatabase;
        this.initializeDefaultSchemasLoader();
    }

    public DefaultSchemasLoader(BatchWriter batchWriter) {
        super(batchWriter);
        this.initializeDefaultSchemasLoader();
    }

    protected void initializeDefaultSchemasLoader() {
        this.addDocumentFileProcessor(new TdeDocumentFileProcessor(this.schemasDatabaseClient, this.tdeValidationDatabase));
        this.addFileFilter(new DefaultFileFilter());
    }

    @Override
    public List<DocumentFile> loadSchemas(String ... paths) {
        return super.loadFiles(paths);
    }

    public String getTdeValidationDatabase() {
        return this.tdeValidationDatabase;
    }

    public void setTdeValidationDatabase(String tdeValidationDatabase) {
        this.tdeValidationDatabase = tdeValidationDatabase;
    }
}

