/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;

public class PropertiesModuleManager
extends LoggingObject
implements ModulesManager {
    public static final String DEFAULT_FILE_PATH = "build/ml-javaclient-util/module-timestamps.properties";
    private Properties props = new Properties();
    private String propertiesFilePath;
    private long minimumFileTimestampToLoad;
    private String host;

    public PropertiesModuleManager() {
        this(DEFAULT_FILE_PATH);
    }

    public PropertiesModuleManager(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
    }

    public PropertiesModuleManager(String propertiesFilePath, DatabaseClient client) {
        this(propertiesFilePath);
        if (client != null) {
            this.host = client.getHost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.props = new Properties();
        File propertiesFile = new File(this.propertiesFilePath);
        if (propertiesFile.getParentFile() != null) {
            propertiesFile.getParentFile().mkdirs();
        }
        if (propertiesFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loading properties from: " + propertiesFile.getAbsolutePath());
                }
                this.props.load(fis);
            }
            catch (Exception e) {
                this.logger.warn("Unable to load properties, cause: " + e.getMessage());
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    this.logger.warn(e.getMessage());
                }
            }
        }
    }

    public void deletePropertiesFile() {
        File propertiesFile = new File(this.propertiesFilePath);
        if (propertiesFile.exists()) {
            propertiesFile.delete();
            this.props.clear();
        }
    }

    @Override
    public boolean hasFileBeenModifiedSinceLastLoaded(File file) {
        if (this.minimumFileTimestampToLoad > 0L && file.lastModified() <= this.minimumFileTimestampToLoad) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("lastModified for file '%s' is %d, which is before the minimumFileTimestampToLoad of %d", file.getAbsolutePath(), file.lastModified(), this.minimumFileTimestampToLoad));
            }
            return false;
        }
        String key = this.buildKey(file);
        String value = this.props.getProperty(key);
        if (value != null) {
            long lastLoaded;
            long lastModified = file.lastModified();
            return lastModified > (lastLoaded = Long.parseLong(value));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLastLoadedTimestamp(File file, Date date) {
        String key = this.buildKey(file);
        this.props.setProperty(key, "" + date.getTime());
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(this.propertiesFilePath));
            this.props.store(fw, "");
        }
        catch (Exception e) {
            this.logger.warn("Unable to store properties, cause: " + e.getMessage());
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage());
            }
        }
    }

    protected String buildKey(File file) {
        String key;
        String path = file.getAbsolutePath().toLowerCase();
        String string = key = this.host != null ? this.host + ":" + path : path;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Key for file " + file.getAbsolutePath() + ": " + key);
        }
        return key;
    }

    public void setMinimumFileTimestampToLoad(long minimumFileTimestampToLoad) {
        this.minimumFileTimestampToLoad = minimumFileTimestampToLoad;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

