/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.temporal;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.rest.util.ResourcesFragment;

public class TemporalCollectionLSQTManager
extends AbstractManager {
    private String databaseIdOrName;
    private String temporalCollectionName;
    private ManageClient manageClient;

    public TemporalCollectionLSQTManager(ManageClient client, String databaseIdOrName, String temporalCollectionName) {
        this.manageClient = client;
        this.databaseIdOrName = databaseIdOrName;
        this.temporalCollectionName = temporalCollectionName;
    }

    private String getResourcesPath() {
        return this.format("/manage/v2/databases/%s/temporal/collections", new Object[]{this.databaseIdOrName});
    }

    public String getPropertiesPath() {
        return this.format("%s/lsqt/properties?collection=%s", new Object[]{this.getResourcesPath(), this.temporalCollectionName});
    }

    public boolean isTemporalCollectionExists() {
        ResourcesFragment temporalCollections = new ResourcesFragment(this.manageClient.getXml(this.getResourcesPath(), new String[0]));
        return temporalCollections.resourceExists(this.temporalCollectionName);
    }

    public void save(String payload) {
        if (this.isTemporalCollectionExists()) {
            String path = this.getPropertiesPath();
            this.logger.info(this.format("Updating LSQT properties for %s temporal collection", new Object[]{this.temporalCollectionName}));
            this.putPayload(this.manageClient, path, payload);
            this.logger.info(this.format("Updated LSQT properties for %s temporal collection", new Object[]{this.temporalCollectionName}));
        } else {
            this.logger.warn(this.format("Temporal collection %s not found. No update to LSQT settings applied", new Object[]{this.temporalCollectionName}));
        }
    }

    public ManageClient getManageClient() {
        return this.manageClient;
    }
}

