/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ProtectedCollectionsManager
extends AbstractResourceManager {
    public ProtectedCollectionsManager(ManageClient client) {
        super(client);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    @Override
    public String getResourcesPath() {
        return "/manage/v2/protected-collections";
    }

    @Override
    protected String getIdFieldName() {
        return "collection";
    }

    @Override
    public String getPropertiesPath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.getResourcesPath() + "/properties?collection=" + this.encodeCollectionName(resourceNameOrId);
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.getResourcesPath() + "?collection=" + this.encodeCollectionName(resourceNameOrId);
    }

    private String encodeCollectionName(String collectionName) {
        try {
            return URLEncoder.encode(collectionName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn(this.format("Unable to encode collection: %s; will include un-encoded collection name in querystring; cause: %s", new Object[]{collectionName, e.getMessage()}));
            return collectionName;
        }
    }
}

