/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.hosts;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.rest.util.Fragment;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.http.ResponseEntity;

public class HostManager
extends AbstractManager {
    private ManageClient client;

    public HostManager(ManageClient client) {
        this.client = client;
    }

    public List<String> getHostIds() {
        return this.getHosts().getElementValues("/h:host-default-list/h:list-items/h:list-item/h:idref");
    }

    public List<String> getHostNames() {
        return this.getHosts().getElementValues("/h:host-default-list/h:list-items/h:list-item/h:nameref");
    }

    public Map<String, String> getHostIdsAndNames() {
        Fragment xml = this.getHosts();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Namespace ns = Namespace.getNamespace((String)"http://marklogic.com/manage/hosts");
        for (Element el : xml.getElements("/h:host-default-list/h:list-items/h:list-item")) {
            String hostId = el.getChildText("idref", ns);
            String hostName = el.getChildText("nameref", ns);
            map.put(hostId, hostName);
        }
        return map;
    }

    public Fragment getHosts() {
        return this.client.getXml("/manage/v2/hosts", new String[0]);
    }

    public ResponseEntity<String> setHostToGroup(String hostIdOrName, String groupIdOrName) {
        String json = this.format("{\"group\":\"%s\"}", new Object[]{groupIdOrName});
        String url = this.format("/manage/v2/hosts/%s/properties", new Object[]{hostIdOrName});
        return this.client.putJson(url, json);
    }

    public String getAssignedGroupName(String hostIdOrName) {
        String url = this.format("/manage/v2/hosts/%s/properties", new Object[]{hostIdOrName});
        return this.payloadParser.getPayloadFieldValue(this.client.getJson(url), "group");
    }
}

