/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.clusters;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.ActionRequiringRestart;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.rest.util.Fragment;
import org.springframework.web.client.ResourceAccessException;

public class ClusterManager
extends AbstractManager {
    private ManageClient manageClient;

    public ClusterManager(ManageClient client) {
        this.manageClient = client;
    }

    public void restartLocalCluster() {
        this.manageClient.postJson("/manage/v2", "{\"operation\":\"restart-local-cluster\"}");
    }

    public void restartLocalCluster(AdminManager adminManager) {
        adminManager.invokeActionRequiringRestart(new ActionRequiringRestart(){

            @Override
            public boolean execute() {
                ClusterManager.this.restartLocalCluster();
                return true;
            }
        });
    }

    public void modifyLocalCluster(final String payload, AdminManager adminManager) {
        adminManager.invokeActionRequiringRestart(new ActionRequiringRestart(){

            @Override
            public boolean execute() {
                block2: {
                    try {
                        ClusterManager.this.putPayload(ClusterManager.this.manageClient, "/manage/v2/properties", payload);
                    }
                    catch (ResourceAccessException rae) {
                        if (!ClusterManager.this.logger.isInfoEnabled()) break block2;
                        ClusterManager.this.logger.info("Ignoring somewhat expected error while updating local cluster properties: " + rae.getMessage());
                    }
                }
                return true;
            }
        });
    }

    public Fragment getLocalClusterProperties() {
        return this.manageClient.getXml("/manage/v2/properties", new String[0]);
    }

    public String getVersion() {
        Fragment f = this.manageClient.getXml("/manage/v2", new String[0]);
        return f.getElementValue("/c:local-cluster-default/c:version");
    }

    public void addHost(AdminManager adminManager, String hostname) throws Exception {
        this.addHost(adminManager, hostname, "Default", null);
    }

    public void addHost(AdminManager adminManager, String hostname, String group, String zone) throws Exception {
        AdminConfig adminConfig = adminManager.getAdminConfig();
        AdminConfig joiningHostAdminConfig = new AdminConfig(adminConfig);
        joiningHostAdminConfig.setHost(hostname);
        AdminManager joiningHostAdminManager = new AdminManager(joiningHostAdminConfig);
        Fragment fragment = joiningHostAdminManager.getServerConfig();
        String hostId = fragment.getElementValue("node()/m:host-id");
        if (hostId.isEmpty()) {
            throw new IllegalStateException("New host [" + hostname + "] has not been initialized. Please initialize the host first.");
        }
        byte[] clusterConfigZipBytes = adminManager.postJoiningHostConfig(fragment, group, zone);
        if (clusterConfigZipBytes == null) {
            throw new RuntimeException("Error sending new host's config to cluster and receiving updated cluster configuration");
        }
        joiningHostAdminManager.postClustConfigToJoiningHost(clusterConfigZipBytes);
    }

    public void removeHost(String hostname) {
        this.removeHost(hostname, 8001);
    }

    public void removeHost(String hostname, int adminPort) {
        AdminConfig removeConfig = new AdminConfig(this.manageClient.getManageConfig());
        removeConfig.setHost(hostname);
        removeConfig.setPort(adminPort);
        new AdminManager(removeConfig).leaveCluster();
    }
}

