/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.alert;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.AbstractResourceManager;

public class AlertConfigManager
extends AbstractResourceManager {
    private String databaseIdOrName;

    public AlertConfigManager(ManageClient client, String databaseIdOrName) {
        super(client);
        this.databaseIdOrName = databaseIdOrName;
    }

    @Override
    public String getResourcesPath() {
        return this.format("/manage/v2/databases/%s/alert/configs", new Object[]{this.databaseIdOrName});
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.getResourcesPath();
    }

    @Override
    protected String[] getUpdateResourceParams(String payload) {
        return new String[]{"uri", this.payloadParser.getPayloadFieldValue(payload, "uri")};
    }

    @Override
    protected String getIdFieldName() {
        return "uri";
    }

    @Override
    public SaveReceipt save(String payload) {
        SaveReceipt receipt = super.save(payload);
        if (receipt.hasLocationHeader()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Immediately updating alert config after it's been created to ensure that CPF domains are set");
            }
            return super.updateResource(payload, this.getResourceId(payload));
        }
        return receipt;
    }

    public void deleteAllConfigs() {
        for (String nameref : this.getAsXml().getListItemNameRefs()) {
            this.deleteByIdField(nameref, new String[0]);
        }
    }
}

