/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.group.ModuleLocation;
import com.marklogic.mgmt.api.group.Namespace;
import com.marklogic.mgmt.api.group.Schema;
import com.marklogic.mgmt.api.server.RequestBlackout;
import com.marklogic.mgmt.api.server.UsingNamespace;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Server
extends Resource {
    @XmlElement(name="server-name")
    private String serverName;
    @XmlElement(name="server-type")
    private String serverType;
    @XmlElement(name="group-name")
    private String groupName;
    private Boolean enabled;
    private String root;
    private Integer port;
    @XmlElement(name="webDAV")
    private Boolean webDAV;
    private Boolean execute;
    @XmlElement(name="modules-database")
    private String modulesDatabase;
    @XmlElement(name="content-database")
    private String contentDatabase;
    @XmlElement(name="last-login-database")
    private String lastLoginDatabase;
    @XmlElement(name="display-last-login")
    private Boolean displayLastLogin;
    private String address;
    private Integer backlog;
    private Integer threads;
    @XmlElement(name="request-timeout")
    private Integer requestTimeout;
    @XmlElement(name="keep-alive-timeout")
    private Integer keepAliveTimeout;
    @XmlElement(name="session-timeout")
    private Integer sessionTimeout;
    @XmlElement(name="max-time-limit")
    private Integer maxTimeLimit;
    @XmlElement(name="default-time-limit")
    private Integer defaultTimeLimit;
    @XmlElement(name="max-inference-size")
    private Integer maxInferenceSize;
    @XmlElement(name="default-inference-size")
    private Integer defaultInferenceSize;
    @XmlElement(name="static-expires")
    private Integer staticExpires;
    @XmlElement(name="pre-commit-trigger-depth")
    private Integer preCommitTriggerDepth;
    @XmlElement(name="pre-commit-trigger-limit")
    private Integer preCommitTriggerLimit;
    private String collation;
    @XmlElement(name="coordinate-system")
    private String coordinateSystem;
    private String authentication;
    @XmlElement(name="internal-security")
    private Boolean internalSecurity;
    @XmlElementWrapper(name="external-securities")
    @XmlElement(name="external-security")
    private List<String> externalSecurity;
    @XmlElement(name="default-user")
    private String defaultUser;
    private String privilege;
    @XmlElement(name="concurrent-request-limit")
    private Integer concurrentRequestLimit;
    @XmlElement(name="compute-content-length")
    private Boolean computeContentLength;
    @XmlElement(name="log-errors")
    private Boolean logErrors;
    @XmlElement(name="debug-allow")
    private Boolean debugAllow;
    @XmlElement(name="profile-allow")
    private Boolean profileAllow;
    @XmlElement(name="default-xquery-version")
    private String defaultXqueryVersion;
    @XmlElement(name="multi-version-concurrency-control")
    private String multiVersionConcurrencyControl;
    @XmlElement(name="distribute-timestamps")
    private String distributeTimestamps;
    @XmlElement(name="output-sgml-character-entities")
    private String outputSgmlCharacterEntities;
    @XmlElement(name="output-encoding")
    private String outputEncoding;
    @XmlElement(name="output-method")
    private String outputMethod;
    @XmlElement(name="output-byte-order-mark")
    private String outputByteOrderMark;
    @XmlElement(name="output-cdata-section-namespace-uri")
    private String outputCdataSectionNamespaceUri;
    @XmlElement(name="output-cdata-section-localname")
    private String outputCdataSectionLocalname;
    @XmlElement(name="output-doctype-public")
    private String outputDoctypePublic;
    @XmlElement(name="output-doctype-system")
    private String outputDoctypeSystem;
    @XmlElement(name="output-escape-uri-attributes")
    private String outputEscapeUriAttributes;
    @XmlElement(name="output-include-content-type")
    private String outputIncludeContentType;
    @XmlElement(name="output-indent")
    private String outputIndent;
    @XmlElement(name="output-indent-untyped")
    private String outputIndentUntyped;
    @XmlElement(name="output-indent-tabs")
    private String outputIndentTabs;
    @XmlElement(name="output-media-type")
    private String outputMediaType;
    @XmlElement(name="output-normalization-form")
    private String outputNormalizationForm;
    @XmlElement(name="output-omit-xml-declaration")
    private String outputOmitXmlDeclaration;
    @XmlElement(name="output-standalone")
    private String outputStandalone;
    @XmlElement(name="output-undeclare-prefixes")
    private String outputUndeclarePrefixes;
    @XmlElement(name="output-version")
    private String outputVersion;
    @XmlElement(name="output-include-default-attributes")
    private String outputIncludeDefaultAttributes;
    @XmlElement(name="default-error-format")
    private String defaultErrorFormat;
    @XmlElement(name="error-handler")
    private String errorHandler;
    @XmlElementWrapper(name="schemas")
    @XmlElement(name="schema")
    private List<Schema> schema;
    @XmlElementWrapper(name="namespaces")
    @XmlElement(name="namespace")
    private List<Namespace> namespace;
    @XmlElementWrapper(name="using-namespaces")
    @XmlElement(name="using-namespace")
    private List<UsingNamespace> usingNamespace;
    @XmlElementWrapper(name="module-locations")
    @XmlElement(name="module-location")
    private List<ModuleLocation> moduleLocation;
    @XmlElementWrapper(name="request-blackouts")
    @XmlElement(name="request-blackout")
    private List<RequestBlackout> requestBlackout;
    @XmlElement(name="url-rewriter")
    private String urlRewriter;
    @XmlElement(name="rewrite-resolves-globally")
    private Boolean rewriteResolvesGlobally;
    @XmlElement(name="ssl-certificate-template")
    private String sslCertificateTemplate;
    @XmlElement(name="ssl-allow-sslv3")
    private Boolean sslAllowSslv3;
    @XmlElement(name="ssl-allow-tls")
    private Boolean sslAllowTls;
    @XmlElement(name="ssl-disable-sslv3")
    private Boolean sslDisableSslv3;
    @XmlElement(name="ssl-disable-tlsv1")
    private Boolean sslDisableTlsv1;
    @XmlElement(name="ssl-disable-tlsv1-1")
    @JsonProperty(value="ssl-disable-tlsv1-1")
    private Boolean sslDisableTlsv11;
    @XmlElement(name="ssl-disable-tlsv1-2")
    @JsonProperty(value="ssl-disable-tlsv1-2")
    private Boolean sslDisableTlsv12;
    @XmlElement(name="ssl-hostname")
    private String sslHostname;
    @XmlElement(name="ssl-ciphers")
    private String sslCiphers;
    @XmlElement(name="ssl-require-client-certificate")
    private Boolean sslRequireClientCertificate;
    @XmlElementWrapper(name="ssl-client-certificate-authorities")
    @XmlElement(name="ssl-client-certificate-authority")
    private List<String> sslClientCertificateAuthority;
    @XmlElementWrapper(name="ssl-client-certificate-pems")
    @XmlElement(name="ssl-client-certificate-pem")
    private List<String> sslClientCertificatePem;

    public Server() {
    }

    public Server(API api, String serverName) {
        super(api);
        this.serverName = serverName;
    }

    @Override
    protected ResourceManager getResourceManager() {
        String name = this.groupName != null ? this.groupName : "Default";
        return new ServerManager(this.getClient(), name);
    }

    @Override
    protected String getResourceId() {
        return this.serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getWebDAV() {
        return this.webDAV;
    }

    public void setWebDAV(Boolean webDAV) {
        this.webDAV = webDAV;
    }

    public Boolean getExecute() {
        return this.execute;
    }

    public void setExecute(Boolean execute) {
        this.execute = execute;
    }

    public Boolean getDisplayLastLogin() {
        return this.displayLastLogin;
    }

    public void setDisplayLastLogin(Boolean displayLastLogin) {
        this.displayLastLogin = displayLastLogin;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getBacklog() {
        return this.backlog;
    }

    public void setBacklog(Integer backlog) {
        this.backlog = backlog;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Integer getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Integer keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Integer getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public void setMaxTimeLimit(Integer maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public Integer getDefaultTimeLimit() {
        return this.defaultTimeLimit;
    }

    public void setDefaultTimeLimit(Integer defaultTimeLimit) {
        this.defaultTimeLimit = defaultTimeLimit;
    }

    public Integer getMaxInferenceSize() {
        return this.maxInferenceSize;
    }

    public void setMaxInferenceSize(Integer maxInferenceSize) {
        this.maxInferenceSize = maxInferenceSize;
    }

    public Integer getDefaultInferenceSize() {
        return this.defaultInferenceSize;
    }

    public void setDefaultInferenceSize(Integer defaultInferenceSize) {
        this.defaultInferenceSize = defaultInferenceSize;
    }

    public Integer getStaticExpires() {
        return this.staticExpires;
    }

    public void setStaticExpires(Integer staticExpires) {
        this.staticExpires = staticExpires;
    }

    public Integer getPreCommitTriggerDepth() {
        return this.preCommitTriggerDepth;
    }

    public void setPreCommitTriggerDepth(Integer preCommitTriggerDepth) {
        this.preCommitTriggerDepth = preCommitTriggerDepth;
    }

    public Integer getPreCommitTriggerLimit() {
        return this.preCommitTriggerLimit;
    }

    public void setPreCommitTriggerLimit(Integer preCommitTriggerLimit) {
        this.preCommitTriggerLimit = preCommitTriggerLimit;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public Boolean getInternalSecurity() {
        return this.internalSecurity;
    }

    public void setInternalSecurity(Boolean internalSecurity) {
        this.internalSecurity = internalSecurity;
    }

    public Integer getConcurrentRequestLimit() {
        return this.concurrentRequestLimit;
    }

    public void setConcurrentRequestLimit(Integer concurrentRequestLimit) {
        this.concurrentRequestLimit = concurrentRequestLimit;
    }

    public Boolean getComputeContentLength() {
        return this.computeContentLength;
    }

    public void setComputeContentLength(Boolean computeContentLength) {
        this.computeContentLength = computeContentLength;
    }

    public Boolean getLogErrors() {
        return this.logErrors;
    }

    public void setLogErrors(Boolean logErrors) {
        this.logErrors = logErrors;
    }

    public Boolean getDebugAllow() {
        return this.debugAllow;
    }

    public void setDebugAllow(Boolean debugAllow) {
        this.debugAllow = debugAllow;
    }

    public Boolean getProfileAllow() {
        return this.profileAllow;
    }

    public void setProfileAllow(Boolean profileAllow) {
        this.profileAllow = profileAllow;
    }

    public String getDefaultXqueryVersion() {
        return this.defaultXqueryVersion;
    }

    public void setDefaultXqueryVersion(String defaultXqueryVersion) {
        this.defaultXqueryVersion = defaultXqueryVersion;
    }

    public String getMultiVersionConcurrencyControl() {
        return this.multiVersionConcurrencyControl;
    }

    public void setMultiVersionConcurrencyControl(String multiVersionConcurrencyControl) {
        this.multiVersionConcurrencyControl = multiVersionConcurrencyControl;
    }

    public String getDistributeTimestamps() {
        return this.distributeTimestamps;
    }

    public void setDistributeTimestamps(String distributeTimestamps) {
        this.distributeTimestamps = distributeTimestamps;
    }

    public String getOutputSgmlCharacterEntities() {
        return this.outputSgmlCharacterEntities;
    }

    public void setOutputSgmlCharacterEntities(String outputSgmlCharacterEntities) {
        this.outputSgmlCharacterEntities = outputSgmlCharacterEntities;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getOutputMethod() {
        return this.outputMethod;
    }

    public void setOutputMethod(String outputMethod) {
        this.outputMethod = outputMethod;
    }

    public String getOutputByteOrderMark() {
        return this.outputByteOrderMark;
    }

    public void setOutputByteOrderMark(String outputByteOrderMark) {
        this.outputByteOrderMark = outputByteOrderMark;
    }

    public String getOutputCdataSectionNamespaceUri() {
        return this.outputCdataSectionNamespaceUri;
    }

    public void setOutputCdataSectionNamespaceUri(String outputCdataSectionNamespaceUri) {
        this.outputCdataSectionNamespaceUri = outputCdataSectionNamespaceUri;
    }

    public String getOutputCdataSectionLocalname() {
        return this.outputCdataSectionLocalname;
    }

    public void setOutputCdataSectionLocalname(String outputCdataSectionLocalname) {
        this.outputCdataSectionLocalname = outputCdataSectionLocalname;
    }

    public String getOutputDoctypePublic() {
        return this.outputDoctypePublic;
    }

    public void setOutputDoctypePublic(String outputDoctypePublic) {
        this.outputDoctypePublic = outputDoctypePublic;
    }

    public String getOutputDoctypeSystem() {
        return this.outputDoctypeSystem;
    }

    public void setOutputDoctypeSystem(String outputDoctypeSystem) {
        this.outputDoctypeSystem = outputDoctypeSystem;
    }

    public String getOutputEscapeUriAttributes() {
        return this.outputEscapeUriAttributes;
    }

    public void setOutputEscapeUriAttributes(String outputEscapeUriAttributes) {
        this.outputEscapeUriAttributes = outputEscapeUriAttributes;
    }

    public String getOutputIncludeContentType() {
        return this.outputIncludeContentType;
    }

    public void setOutputIncludeContentType(String outputIncludeContentType) {
        this.outputIncludeContentType = outputIncludeContentType;
    }

    public String getOutputIndent() {
        return this.outputIndent;
    }

    public void setOutputIndent(String outputIndent) {
        this.outputIndent = outputIndent;
    }

    public String getOutputIndentUntyped() {
        return this.outputIndentUntyped;
    }

    public void setOutputIndentUntyped(String outputIndentUntyped) {
        this.outputIndentUntyped = outputIndentUntyped;
    }

    public String getOutputIndentTabs() {
        return this.outputIndentTabs;
    }

    public void setOutputIndentTabs(String outputIndentTabs) {
        this.outputIndentTabs = outputIndentTabs;
    }

    public String getOutputMediaType() {
        return this.outputMediaType;
    }

    public void setOutputMediaType(String outputMediaType) {
        this.outputMediaType = outputMediaType;
    }

    public String getOutputNormalizationForm() {
        return this.outputNormalizationForm;
    }

    public void setOutputNormalizationForm(String outputNormalizationForm) {
        this.outputNormalizationForm = outputNormalizationForm;
    }

    public String getOutputOmitXmlDeclaration() {
        return this.outputOmitXmlDeclaration;
    }

    public void setOutputOmitXmlDeclaration(String outputOmitXmlDeclaration) {
        this.outputOmitXmlDeclaration = outputOmitXmlDeclaration;
    }

    public String getOutputStandalone() {
        return this.outputStandalone;
    }

    public void setOutputStandalone(String outputStandalone) {
        this.outputStandalone = outputStandalone;
    }

    public String getOutputUndeclarePrefixes() {
        return this.outputUndeclarePrefixes;
    }

    public void setOutputUndeclarePrefixes(String outputUndeclarePrefixes) {
        this.outputUndeclarePrefixes = outputUndeclarePrefixes;
    }

    public String getOutputVersion() {
        return this.outputVersion;
    }

    public void setOutputVersion(String outputVersion) {
        this.outputVersion = outputVersion;
    }

    public String getOutputIncludeDefaultAttributes() {
        return this.outputIncludeDefaultAttributes;
    }

    public void setOutputIncludeDefaultAttributes(String outputIncludeDefaultAttributes) {
        this.outputIncludeDefaultAttributes = outputIncludeDefaultAttributes;
    }

    public String getDefaultErrorFormat() {
        return this.defaultErrorFormat;
    }

    public void setDefaultErrorFormat(String defaultErrorFormat) {
        this.defaultErrorFormat = defaultErrorFormat;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(String urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public Boolean getRewriteResolvesGlobally() {
        return this.rewriteResolvesGlobally;
    }

    public void setRewriteResolvesGlobally(Boolean rewriteResolvesGlobally) {
        this.rewriteResolvesGlobally = rewriteResolvesGlobally;
    }

    public Boolean getSslAllowSslv3() {
        return this.sslAllowSslv3;
    }

    public void setSslAllowSslv3(Boolean sslAllowSslv3) {
        this.sslAllowSslv3 = sslAllowSslv3;
    }

    public Boolean getSslAllowTls() {
        return this.sslAllowTls;
    }

    public void setSslAllowTls(Boolean sslAllowTls) {
        this.sslAllowTls = sslAllowTls;
    }

    public String getSslHostname() {
        return this.sslHostname;
    }

    public void setSslHostname(String sslHostname) {
        this.sslHostname = sslHostname;
    }

    public String getSslCiphers() {
        return this.sslCiphers;
    }

    public void setSslCiphers(String sslCiphers) {
        this.sslCiphers = sslCiphers;
    }

    public Boolean getSslRequireClientCertificate() {
        return this.sslRequireClientCertificate;
    }

    public void setSslRequireClientCertificate(Boolean sslRequireClientCertificate) {
        this.sslRequireClientCertificate = sslRequireClientCertificate;
    }

    public String getContentDatabase() {
        return this.contentDatabase;
    }

    public void setContentDatabase(String contentDatabase) {
        this.contentDatabase = contentDatabase;
    }

    public String getModulesDatabase() {
        return this.modulesDatabase;
    }

    public void setModulesDatabase(String modulesDatabase) {
        this.modulesDatabase = modulesDatabase;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getPrivilege() {
        return this.privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege;
    }

    public String getLastLoginDatabase() {
        return this.lastLoginDatabase;
    }

    public void setLastLoginDatabase(String lastLoginDatabase) {
        this.lastLoginDatabase = lastLoginDatabase;
    }

    public String getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(String coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public List<String> getExternalSecurity() {
        return this.externalSecurity;
    }

    public void setExternalSecurity(List<String> externalSecurity) {
        this.externalSecurity = externalSecurity;
    }

    public List<Schema> getSchema() {
        return this.schema;
    }

    public void setSchema(List<Schema> schema) {
        this.schema = schema;
    }

    public List<Namespace> getNamespace() {
        return this.namespace;
    }

    public void setNamespace(List<Namespace> namespace) {
        this.namespace = namespace;
    }

    public List<UsingNamespace> getUsingNamespace() {
        return this.usingNamespace;
    }

    public void setUsingNamespace(List<UsingNamespace> usingNamespace) {
        this.usingNamespace = usingNamespace;
    }

    public List<ModuleLocation> getModuleLocation() {
        return this.moduleLocation;
    }

    public void setModuleLocation(List<ModuleLocation> moduleLocation) {
        this.moduleLocation = moduleLocation;
    }

    public List<RequestBlackout> getRequestBlackout() {
        return this.requestBlackout;
    }

    public void setRequestBlackout(List<RequestBlackout> requestBlackout) {
        this.requestBlackout = requestBlackout;
    }

    public Boolean getSslDisableSslv3() {
        return this.sslDisableSslv3;
    }

    public void setSslDisableSslv3(Boolean sslDisableSslv3) {
        this.sslDisableSslv3 = sslDisableSslv3;
    }

    public Boolean getSslDisableTlsv1() {
        return this.sslDisableTlsv1;
    }

    public void setSslDisableTlsv1(Boolean sslDisableTlsv1) {
        this.sslDisableTlsv1 = sslDisableTlsv1;
    }

    public Boolean getSslDisableTlsv11() {
        return this.sslDisableTlsv11;
    }

    public void setSslDisableTlsv11(Boolean sslDisableTlsv11) {
        this.sslDisableTlsv11 = sslDisableTlsv11;
    }

    public Boolean getSslDisableTlsv12() {
        return this.sslDisableTlsv12;
    }

    public void setSslDisableTlsv12(Boolean sslDisableTlsv12) {
        this.sslDisableTlsv12 = sslDisableTlsv12;
    }

    public List<String> getSslClientCertificateAuthority() {
        return this.sslClientCertificateAuthority;
    }

    public void setSslClientCertificateAuthority(List<String> sslClientCertificateAuthority) {
        this.sslClientCertificateAuthority = sslClientCertificateAuthority;
    }

    public List<String> getSslClientCertificatePem() {
        return this.sslClientCertificatePem;
    }

    public void setSslClientCertificatePem(List<String> sslClientCertificatePem) {
        this.sslClientCertificatePem = sslClientCertificatePem;
    }

    public String getSslCertificateTemplate() {
        return this.sslCertificateTemplate;
    }

    public void setSslCertificateTemplate(String sslCertificateTemplate) {
        this.sslCertificateTemplate = sslCertificateTemplate;
    }
}

