/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.appdeployer.DefaultAppConfigFactory;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.ClientHelper;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.cluster.Cluster;
import com.marklogic.mgmt.api.database.Database;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.api.group.Group;
import com.marklogic.mgmt.api.restapi.RestApi;
import com.marklogic.mgmt.api.security.Amp;
import com.marklogic.mgmt.api.security.ExternalSecurity;
import com.marklogic.mgmt.api.security.Privilege;
import com.marklogic.mgmt.api.security.ProtectedCollection;
import com.marklogic.mgmt.api.security.Role;
import com.marklogic.mgmt.api.security.User;
import com.marklogic.mgmt.api.security.protectedpath.ProtectedPath;
import com.marklogic.mgmt.api.security.queryroleset.QueryRoleset;
import com.marklogic.mgmt.api.server.Server;
import com.marklogic.mgmt.api.task.Task;
import com.marklogic.mgmt.api.trigger.Trigger;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.forests.ForestManager;
import com.marklogic.mgmt.resource.groups.GroupManager;
import com.marklogic.mgmt.resource.security.AmpManager;
import com.marklogic.mgmt.resource.security.ExternalSecurityManager;
import com.marklogic.mgmt.resource.security.PrivilegeManager;
import com.marklogic.mgmt.resource.security.ProtectedCollectionsManager;
import com.marklogic.mgmt.resource.security.ProtectedPathManager;
import com.marklogic.mgmt.resource.security.QueryRolesetManager;
import com.marklogic.mgmt.resource.security.RoleManager;
import com.marklogic.mgmt.resource.security.UserManager;
import com.marklogic.mgmt.resource.tasks.TaskManager;
import com.marklogic.mgmt.resource.triggers.TriggerManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.mgmt.util.SystemPropertySource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class API
extends LoggingObject {
    private ManageClient manageClient;
    private AdminManager adminManager;
    private ObjectMapper objectMapper;

    public API(ManageClient client) {
        this.manageClient = client;
        this.setObjectMapper(this.buildDefaultObjectMapper());
    }

    public API(ManageClient client, AdminManager adminManager) {
        this.manageClient = client;
        this.adminManager = adminManager;
        this.setObjectMapper(this.buildDefaultObjectMapper());
    }

    public API(ManageClient client, ObjectMapper mapper) {
        this.manageClient = client;
        this.objectMapper = mapper;
    }

    protected ObjectMapper buildDefaultObjectMapper() {
        return ObjectMapperFactory.getObjectMapper();
    }

    public void connect(String host) {
        this.connect(host, this.manageClient.getManageConfig());
    }

    public void connect(String host, ManageConfig mc) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Connecting to host: " + host);
        }
        ManageConfig newConfig = new ManageConfig(mc);
        newConfig.setHost(host);
        this.manageClient = new ManageClient(newConfig);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Connected to host: " + host);
        }
    }

    public void connect(String host, String username, String password) {
        this.connect(host, username, password, username, password);
    }

    public void connect(String host, String username, String password, String securityUsername, String securityPassword) {
        ManageConfig mc = new ManageConfig();
        mc.setHost(host);
        mc.setUsername(username);
        mc.setPassword(password);
        mc.setSecurityUsername(securityUsername);
        mc.setSecurityPassword(securityPassword);
        this.connect(host, mc);
    }

    public ClientHelper clientHelper() {
        return new ClientHelper(this.newClient());
    }

    public DatabaseClient newClient() {
        return new DefaultAppConfigFactory(new SystemPropertySource()).newAppConfig().newDatabaseClient();
    }

    public void restart() {
        this.getCluster().restart();
    }

    public Cluster getCluster() {
        return new Cluster(this, this.adminManager);
    }

    public RestApi restApi(String name) {
        return this.restApi(name, null);
    }

    public RestApi restApi(String name, Integer port) {
        RestApi r = new RestApi(this, name);
        r.setPort(port);
        r.setObjectMapper(this.getObjectMapper());
        return r;
    }

    public String createRestApi(String name) {
        return this.restApi(name).save();
    }

    public String createRestApi(String name, Integer port) {
        return this.restApi(name, port).save();
    }

    public Group group() {
        return this.group("Default");
    }

    public Group group(String name) {
        Group g = new Group(this, name);
        return name != null && g.exists() ? this.getResource(name, new GroupManager(this.getManageClient()), Group.class, new String[0]) : g;
    }

    public Group getGroup() {
        return this.group(null);
    }

    public void trace(String ... events) {
        this.group().trace(events);
    }

    public void untrace(String ... events) {
        this.group().untrace(events);
    }

    public Database db(String name) {
        Database db = new Database(this, name);
        return name != null && db.exists() ? this.getResource(name, new DatabaseManager(this.getManageClient()), Database.class, new String[0]) : db;
    }

    public Database getDb() {
        return this.db(null);
    }

    public Forest forest(String name) {
        Forest f = new Forest(this, name);
        return name != null && f.exists() ? this.getResource(name, new ForestManager(this.getManageClient()), Forest.class, new String[0]) : f;
    }

    public Forest getForest() {
        return this.forest(null);
    }

    public ProtectedPath protectedPath(String pathExpression) {
        ProtectedPath path = new ProtectedPath(pathExpression);
        path.setApi(this);
        return pathExpression != null && path.exists() ? this.getResource(pathExpression, new ProtectedPathManager(this.getManageClient()), ProtectedPath.class, new String[0]) : path;
    }

    public QueryRoleset queryRoleset(String ... roleNames) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(Arrays.asList(roleNames));
        QueryRoleset roleset = new QueryRoleset();
        roleset.setApi(this);
        roleset.setRoleName(names);
        return roleNames != null && roleset.exists() ? this.getResource(roleset.getRoleNamesAsJsonArrayString(), new QueryRolesetManager(this.getManageClient()), QueryRoleset.class, new String[0]) : roleset;
    }

    public Server server(String name) {
        return this.server(name, (Integer)null);
    }

    public Server server(String name, String groupName) {
        Server s = new Server(this, name);
        return name != null && s.exists() ? this.getResource(name, new ServerManager(this.getManageClient(), groupName), Server.class, new String[0]) : s;
    }

    public Server server(String name, Integer port) {
        Server s = new Server(this, name);
        s.setPort(port);
        return name != null && s.exists() ? this.getResource(name, new ServerManager(this.getManageClient()), Server.class, new String[0]) : s;
    }

    public Server getServer() {
        return this.server(null);
    }

    public Trigger trigger(String name, String databaseName) {
        Trigger t = new Trigger();
        t.setApi(this);
        t.setName(name);
        t.setDatabaseName(databaseName);
        if (name != null && t.exists()) {
            return this.getResource(name, new TriggerManager(this.getManageClient(), databaseName), Trigger.class, new String[0]);
        }
        return t;
    }

    public Amp amp(String localName, String namespace, String documentUri, String modulesDatabase) {
        Amp amp = new Amp(this, localName);
        amp.setNamespace(namespace);
        amp.setDocumentUri(documentUri);
        amp.setModulesDatabase(modulesDatabase);
        return localName != null && amp.exists() ? this.getResource(localName, new AmpManager(this.getManageClient()), Amp.class, amp.getResourceUrlParams()) : amp;
    }

    public Amp getAmp() {
        return this.amp(null, null, null, null);
    }

    public ExternalSecurity externalSecurity(String name) {
        ExternalSecurity es = new ExternalSecurity(this, name);
        return name != null && es.exists() ? this.getResource(name, new ExternalSecurityManager(this.getManageClient()), ExternalSecurity.class, new String[0]) : es;
    }

    public ExternalSecurity externalSecurity() {
        return this.externalSecurity(null);
    }

    public Privilege privilegeExecute(String name) {
        Privilege p = new Privilege(this, name);
        return name != null && p.exists() ? this.getResource(name, new PrivilegeManager(this.getManageClient()), Privilege.class, "kind", "execute") : p;
    }

    public Privilege getPrivilegeExecute() {
        return this.privilegeExecute(null);
    }

    public Privilege privilegeUri(String name) {
        Privilege p = new Privilege(this, name);
        return name != null && p.exists() ? this.getResource(name, new PrivilegeManager(this.getManageClient()), Privilege.class, "kind", "uri") : p;
    }

    public Privilege getPrivilegeUri() {
        return this.privilegeUri(null);
    }

    public ProtectedCollection protectedCollection(String name) {
        ProtectedCollection pc = new ProtectedCollection(this, name);
        return name != null && pc.exists() ? this.getResource(name, new ProtectedCollectionsManager(this.getManageClient()), ProtectedCollection.class, new String[0]) : pc;
    }

    public ProtectedCollection getProtectedCollection() {
        return this.protectedCollection(null);
    }

    public User user(String name) {
        User u = new User(this, name);
        return name != null && u.exists() ? this.getResource(name, new UserManager(this.getManageClient()), User.class, new String[0]) : u;
    }

    public User getUser() {
        return this.user(null);
    }

    public Role role(String name) {
        Role r = new Role(this, name);
        return name != null && r.exists() ? this.getResource(name, new RoleManager(this.getManageClient()), Role.class, new String[0]) : r;
    }

    public Role getRole() {
        return this.role(null);
    }

    public Task task(String taskId) {
        return this.task(taskId, "Default");
    }

    public Task task(String taskId, String groupId) {
        Task t = new Task(this, taskId);
        return taskId != null && t.exists() ? this.getResource(taskId, new TaskManager(this.getManageClient()), Task.class, "group-id", groupId) : t;
    }

    public Task getTask() {
        return this.task(null);
    }

    protected <T extends Resource> T getResource(String resourceNameOrId, ResourceManager mgr, Class<T> resourceClass, String ... resourceUrlParams) {
        if (mgr.exists(resourceNameOrId, new String[0])) {
            return this.buildFromJson(mgr.getAsJson(resourceNameOrId, resourceUrlParams), resourceClass);
        }
        throw new RuntimeException("Could not find resource with name or ID: " + resourceNameOrId);
    }

    protected <T extends Resource> T buildFromJson(String json, Class<T> clazz) {
        try {
            Resource resource = (Resource)this.getObjectMapper().readerFor(clazz).readValue(json);
            resource.setApi(this);
            resource.setObjectMapper(this.getObjectMapper());
            return (T)resource;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to build object from json, cause: " + ex.getMessage(), ex);
        }
    }

    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public void setManageClient(ManageClient client) {
        this.manageClient = client;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public AdminManager getAdminManager() {
        return this.adminManager;
    }

    public void setAdminManager(AdminManager adminManager) {
        this.adminManager = adminManager;
    }
}

