/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.admin;

import com.marklogic.appdeployer.util.JavaClientUtil;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.PropertySourceFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.util.StringUtils;

public class DefaultAdminConfigFactory
extends PropertySourceFactory
implements AdminConfigFactory {
    private Map<String, BiConsumer<AdminConfig, String>> propertyConsumerMap;

    public DefaultAdminConfigFactory() {
        this.initialize();
    }

    public DefaultAdminConfigFactory(PropertySource propertySource) {
        super(propertySource);
        this.initialize();
    }

    public void initialize() {
        this.propertyConsumerMap = new LinkedHashMap<String, BiConsumer<AdminConfig, String>>();
        this.propertyConsumerMap.put("mlAdminHost", (config, prop) -> {
            this.logger.info("Admin interface host: " + prop);
            config.setHost((String)prop);
        });
        this.propertyConsumerMap.put("mlHost", (config, prop) -> {
            if (!this.propertyExists("mlAdminHost")) {
                this.logger.info("Admin interface host: " + prop);
                config.setHost((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlAdminPort", (config, prop) -> {
            this.logger.info("Admin interface port: " + prop);
            config.setPort(this.propertyToInteger("mlAdminPort", (String)prop));
        });
        this.propertyConsumerMap.put("mlAdminAuthentication", (config, prop) -> {
            this.logger.info("Admin authentication: " + prop);
            config.setAuthType((String)prop);
        });
        this.propertyConsumerMap.put("mlAuthentication", (config, prop) -> {
            if (!this.propertyExists("mlAdminAuthentication")) {
                this.logger.info("Admin authentication: " + prop);
                config.setAuthType((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManageUsername", (config, prop) -> {
            this.logger.info("Admin interface username: " + prop);
            config.setUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlUsername", (config, prop) -> {
            if (!this.propertyExists("mlManageUsername")) {
                this.logger.info("Admin interface username: " + prop);
                config.setUsername((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManagePassword", (config, prop) -> config.setPassword((String)prop));
        this.propertyConsumerMap.put("mlPassword", (config, prop) -> {
            if (!this.propertyExists("mlManagePassword")) {
                config.setPassword((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlAdminCertFile", (config, prop) -> {
            this.logger.info("Admin certificate file: " + prop);
            config.setCertFile((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminCertPassword", (config, prop) -> config.setCertPassword((String)prop));
        this.propertyConsumerMap.put("mlAdminExternalName", (config, prop) -> {
            this.logger.info("Admin external name: " + prop);
            config.setExternalName((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminSamlToken", (config, prop) -> config.setSamlToken((String)prop));
        this.propertyConsumerMap.put("mlCloudBasePath", (config, prop) -> {
            String defaultAdminPath = prop + "/admin";
            this.logger.info("Admin base path: " + defaultAdminPath);
            config.setBasePath(defaultAdminPath);
        });
        this.propertyConsumerMap.put("mlAdminBasePath", (config, prop) -> {
            String cloudBasePath = this.getProperty("mlCloudBasePath");
            String adminPath = StringUtils.hasText((String)cloudBasePath) ? cloudBasePath + prop : prop;
            this.logger.info("Admin base path: " + adminPath);
            config.setBasePath(adminPath);
        });
        this.propertyConsumerMap.put("mlAdminSimpleSsl", (config, prop) -> {
            this.logger.info("Use simple SSL for Admin interface: " + prop);
            config.setConfigureSimpleSsl(Boolean.parseBoolean(prop));
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlAdminSslProtocol", (config, prop) -> {
            this.logger.info("Using SSL protocol for Admin app server: " + prop);
            config.setSslProtocol((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlAdminSslHostnameVerifier", (config, prop) -> {
            this.logger.info("Admin SSL hostname verifier: " + prop);
            config.setSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
        });
        this.propertyConsumerMap.put("mlSslHostnameVerifier", (config, prop) -> {
            if (!this.propertyExists("mlAdminSslHostnameVerifier")) {
                this.logger.info("Admin SSL hostname verifier: " + prop);
                config.setSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
            }
        });
        this.propertyConsumerMap.put("mlAdminUseDefaultKeystore", (config, prop) -> {
            this.logger.info("Using default JVM keystore for SSL for Admin app server: " + prop);
            config.setUseDefaultKeystore(Boolean.parseBoolean(prop));
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlAdminTrustManagementAlgorithm", (config, prop) -> {
            this.logger.info("Using trust management algorithm for SSL for Admin app server: " + prop);
            config.setTrustManagementAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStorePath", (config, prop) -> {
            this.logger.info("Admin key store path: " + prop);
            config.setKeyStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlKeyStorePassword", (config, prop) -> config.setKeyStorePassword((String)prop));
        this.propertyConsumerMap.put("mlKeyStoreType", (config, prop) -> {
            this.logger.info("Admin key store type: " + prop);
            config.setKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("Admin key store algorithm: " + prop);
            config.setKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStorePath", (config, prop) -> {
            this.logger.info("Admin trust store path: " + prop);
            config.setTrustStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlTrustStorePassword", (config, prop) -> config.setTrustStorePassword((String)prop));
        this.propertyConsumerMap.put("mlTrustStoreType", (config, prop) -> {
            this.logger.info("Admin trust store type: " + prop);
            config.setTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("Admin trust store algorithm: " + prop);
            config.setTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminKeyStorePath", (config, prop) -> {
            this.logger.info("Admin key store path: " + prop);
            config.setKeyStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlAdminKeyStorePassword", (config, prop) -> config.setKeyStorePassword((String)prop));
        this.propertyConsumerMap.put("mlAdminKeyStoreType", (config, prop) -> {
            this.logger.info("Admin key store type: " + prop);
            config.setKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("Admin key store algorithm: " + prop);
            config.setKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminTrustStorePath", (config, prop) -> {
            this.logger.info("Admin trust store path: " + prop);
            config.setTrustStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlAdminTrustStorePassword", (config, prop) -> config.setTrustStorePassword((String)prop));
        this.propertyConsumerMap.put("mlAdminTrustStoreType", (config, prop) -> {
            this.logger.info("Admin trust store type: " + prop);
            config.setTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("Admin trust store algorithm: " + prop);
            config.setTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminScheme", (config, prop) -> {
            this.logger.info("Admin scheme: " + prop);
            config.setScheme((String)prop);
        });
        this.propertyConsumerMap.put("mlCloudApiKey", (config, prop) -> {
            this.logger.info("Setting Admin cloud API key and forcing scheme to HTTPS and port to 443");
            config.setCloudApiKey((String)prop);
            config.setPort(443);
            config.setScheme("https");
        });
    }

    @Override
    public AdminConfig newAdminConfig() {
        AdminConfig config = new AdminConfig();
        for (String propertyName : this.propertyConsumerMap.keySet()) {
            String value = this.getProperty(propertyName);
            if (value == null) continue;
            this.propertyConsumerMap.get(propertyName).accept(config, value);
        }
        return config;
    }

    public Map<String, BiConsumer<AdminConfig, String>> getPropertyConsumerMap() {
        return this.propertyConsumerMap;
    }
}

