/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt;

import com.marklogic.appdeployer.util.JavaClientUtil;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.ManageConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.PropertySourceFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.util.StringUtils;

public class DefaultManageConfigFactory
extends PropertySourceFactory
implements ManageConfigFactory {
    private Map<String, BiConsumer<ManageConfig, String>> propertyConsumerMap;

    public DefaultManageConfigFactory() {
        this.initialize();
    }

    public DefaultManageConfigFactory(PropertySource propertySource) {
        super(propertySource);
        this.initialize();
    }

    public void initialize() {
        this.propertyConsumerMap = new LinkedHashMap<String, BiConsumer<ManageConfig, String>>();
        this.propertyConsumerMap.put("mlManageHost", (config, prop) -> {
            this.logger.info("Manage host: " + prop);
            config.setHost((String)prop);
        });
        this.propertyConsumerMap.put("mlHost", (config, prop) -> {
            if (!this.propertyExists("mlManageHost")) {
                this.logger.info("Manage host: " + prop);
                config.setHost((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManagePort", (config, prop) -> {
            this.logger.info("Manage port: " + prop);
            config.setPort(this.propertyToInteger("mlManagePort", (String)prop));
        });
        this.propertyConsumerMap.put("mlManageAuthentication", (config, prop) -> {
            this.logger.info("Manage authentication: " + prop);
            config.setAuthType((String)prop);
        });
        this.propertyConsumerMap.put("mlAuthentication", (config, prop) -> {
            if (!this.propertyExists("mlManageAuthentication")) {
                this.logger.info("Manage authentication: " + prop);
                config.setAuthType((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManageUsername", (config, prop) -> {
            this.logger.info("Manage username: " + prop);
            config.setUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlUsername", (config, prop) -> {
            if (!this.propertyExists("mlManageUsername")) {
                this.logger.info("Manage username: " + prop);
                config.setUsername((String)prop);
            }
            if (!this.propertyExists("mlSecurityUsername") && !this.propertyExists("mlAdminUsername")) {
                this.logger.info("Manage user with security role: " + prop);
                config.setSecurityUsername((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManagePassword", (config, prop) -> config.setPassword((String)prop));
        this.propertyConsumerMap.put("mlPassword", (config, prop) -> {
            if (!this.propertyExists("mlManagePassword")) {
                config.setPassword((String)prop);
            }
            if (!this.propertyExists("mlSecurityPassword") && !this.propertyExists("mlAdminPassword")) {
                config.setSecurityPassword((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlManageCertFile", (config, prop) -> {
            this.logger.info("Manage certificate file: " + prop);
            config.setCertFile((String)prop);
        });
        this.propertyConsumerMap.put("mlManageCertPassword", (config, prop) -> config.setCertPassword((String)prop));
        this.propertyConsumerMap.put("mlManageExternalName", (config, prop) -> {
            this.logger.info("Manage external name: " + prop);
            config.setExternalName((String)prop);
        });
        this.propertyConsumerMap.put("mlManageSamlToken", (config, prop) -> config.setSamlToken((String)prop));
        this.propertyConsumerMap.put("mlCloudBasePath", (config, prop) -> {
            String defaultManagePath = prop + "/manage";
            this.logger.info("Manage base path: " + defaultManagePath);
            config.setBasePath(defaultManagePath);
        });
        this.propertyConsumerMap.put("mlManageBasePath", (config, prop) -> {
            String cloudBasePath = this.getProperty("mlCloudBasePath");
            String managePath = StringUtils.hasText((String)cloudBasePath) ? cloudBasePath + prop : prop;
            this.logger.info("Manage base path: " + managePath);
            config.setBasePath(managePath);
        });
        this.propertyConsumerMap.put("mlManageSimpleSsl", (config, prop) -> {
            this.logger.info("Use simple SSL for Manage app server: " + prop);
            config.setConfigureSimpleSsl(Boolean.parseBoolean(prop));
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlManageSslProtocol", (config, prop) -> {
            this.logger.info("Using SSL protocol for Manage app server: " + prop);
            config.setSslProtocol((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlManageSslHostnameVerifier", (config, prop) -> {
            this.logger.info("Manage SSL hostname verifier: " + prop);
            config.setSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
        });
        this.propertyConsumerMap.put("mlSslHostnameVerifier", (config, prop) -> {
            if (!this.propertyExists("mlManageSslHostnameVerifier")) {
                this.logger.info("Manage SSL hostname verifier: " + prop);
                config.setSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
            }
        });
        this.propertyConsumerMap.put("mlManageUseDefaultKeystore", (config, prop) -> {
            this.logger.info("Using default JVM keystore for SSL for Manage app server: " + prop);
            config.setUseDefaultKeystore(Boolean.parseBoolean(prop));
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlManageTrustManagementAlgorithm", (config, prop) -> {
            this.logger.info("Using trust management algorithm for SSL for Manage app server: " + prop);
            config.setTrustManagementAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStorePath", (config, prop) -> {
            this.logger.info("Manage key store path: " + prop);
            config.setKeyStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlKeyStorePassword", (config, prop) -> config.setKeyStorePassword((String)prop));
        this.propertyConsumerMap.put("mlKeyStoreType", (config, prop) -> {
            this.logger.info("Manage key store type: " + prop);
            config.setKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("Manage key store algorithm: " + prop);
            config.setKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStorePath", (config, prop) -> {
            this.logger.info("Manage trust store path: " + prop);
            config.setTrustStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlTrustStorePassword", (config, prop) -> config.setTrustStorePassword((String)prop));
        this.propertyConsumerMap.put("mlTrustStoreType", (config, prop) -> {
            this.logger.info("Manage trust store type: " + prop);
            config.setTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("Manage trust store algorithm: " + prop);
            config.setTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlManageKeyStorePath", (config, prop) -> {
            this.logger.info("Manage key store path: " + prop);
            config.setKeyStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlManageKeyStorePassword", (config, prop) -> config.setKeyStorePassword((String)prop));
        this.propertyConsumerMap.put("mlManageKeyStoreType", (config, prop) -> {
            this.logger.info("Manage key store type: " + prop);
            config.setKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlManageKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("Manage key store algorithm: " + prop);
            config.setKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlManageTrustStorePath", (config, prop) -> {
            this.logger.info("Manage trust store path: " + prop);
            config.setTrustStorePath((String)prop);
            config.setScheme("https");
        });
        this.propertyConsumerMap.put("mlManageTrustStorePassword", (config, prop) -> config.setTrustStorePassword((String)prop));
        this.propertyConsumerMap.put("mlManageTrustStoreType", (config, prop) -> {
            this.logger.info("Manage trust store type: " + prop);
            config.setTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlManageTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("Manage trust store algorithm: " + prop);
            config.setTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlManageCleanJsonPayloads", (config, prop) -> {
            this.logger.info("Cleaning Management API JSON payloads: " + prop);
            config.setCleanJsonPayloads(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAdminUsername", (config, prop) -> {
            this.logger.info("mlAdminUsername is deprecated; please use mlSecurityUsername instead; Manage user with security role: " + prop);
            config.setSecurityUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlAdminPassword", (config, prop) -> {
            this.logger.info("mlAdminPassword is deprecated; please use mlSecurityPassword instead");
            config.setSecurityPassword((String)prop);
        });
        this.propertyConsumerMap.put("mlSecurityUsername", (config, prop) -> {
            this.logger.info("Manage user with security role: " + prop);
            config.setSecurityUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlSecurityPassword", (config, prop) -> config.setSecurityPassword((String)prop));
        this.propertyConsumerMap.put("mlManageScheme", (config, prop) -> {
            this.logger.info("Manage scheme: " + prop);
            config.setScheme((String)prop);
        });
        this.propertyConsumerMap.put("mlCloudApiKey", (config, prop) -> {
            this.logger.info("Setting Manage cloud API key and forcing scheme to HTTPS and port to 443");
            config.setCloudApiKey((String)prop);
            config.setScheme("https");
            config.setPort(443);
        });
    }

    @Override
    public ManageConfig newManageConfig() {
        ManageConfig config = new ManageConfig();
        for (String propertyName : this.propertyConsumerMap.keySet()) {
            String value = this.getProperty(propertyName);
            if (value == null) continue;
            this.propertyConsumerMap.get(propertyName).accept(config, value);
        }
        if (!StringUtils.hasText((String)config.getSecurityUsername())) {
            config.setSecurityUsername(config.getUsername());
        }
        if (!StringUtils.hasText((String)config.getSecurityPassword())) {
            config.setSecurityPassword(config.getPassword());
        }
        return config;
    }

    public Map<String, BiConsumer<ManageConfig, String>> getPropertyConsumerMap() {
        return this.propertyConsumerMap;
    }
}

