/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.impl;

import com.marklogic.appdeployer.export.ExportedResources;
import com.marklogic.appdeployer.export.impl.AbstractResourceExporter;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import java.io.File;
import java.util.ArrayList;

public abstract class AbstractNamedResourceExporter
extends AbstractResourceExporter {
    private String[] resourceNames;

    protected AbstractNamedResourceExporter(ManageClient manageClient, String ... resourceNames) {
        super(manageClient);
        this.resourceNames = resourceNames;
    }

    protected abstract ResourceManager newResourceManager(ManageClient var1);

    protected abstract File getResourceDirectory(File var1);

    @Override
    public ExportedResources exportResources(File baseDir) {
        ArrayList<File> files = new ArrayList<File>();
        if (this.resourceNames != null && this.resourceNames.length > 0) {
            ResourceManager mgr = this.newResourceManager(this.getManageClient());
            File resourceDir = this.getResourceDirectory(baseDir);
            resourceDir.mkdirs();
            for (String resourceName : this.resourceNames) {
                File f = this.exportToFile(mgr, resourceName, resourceDir);
                if (f == null) continue;
                files.add(f);
            }
        }
        return new ExportedResources(files, this.getExportMessages());
    }

    protected String[] getExportMessages() {
        return null;
    }

    public String[] getResourceNames() {
        return this.resourceNames;
    }
}

