/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.triggers;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.triggers.TriggerManager;
import java.io.File;

public class DeployTriggersCommand
extends AbstractResourceCommand {
    private String databaseIdOrName;
    private TriggerManager currentTriggerManager;

    public DeployTriggersCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_TRIGGERS);
        this.setDeleteResourcesOnUndo(false);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            String initialTriggersDatabaseName = this.databaseIdOrName != null ? this.databaseIdOrName : appConfig.getTriggersDatabaseName();
            this.deployTriggers(context, configDir, initialTriggersDatabaseName);
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                if (databaseName == null) continue;
                this.deployTriggers(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployTriggers(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.currentTriggerManager = new TriggerManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getTriggersDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.currentTriggerManager;
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getTriggersDir());
    }

    public void setDatabaseIdOrName(String databaseIdOrName) {
        this.databaseIdOrName = databaseIdOrName;
    }
}

