/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.temporal;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.temporal.TemporalCollectionLSQTManager;
import java.io.File;

public class DeployTemporalCollectionsLSQTCommand
extends AbstractCommand {
    public DeployTemporalCollectionsLSQTCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_TEMPORAL_COLLECTIONS_LSQT);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployTemporalCollectionsLsqt(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                if (databaseName == null) continue;
                this.deployTemporalCollectionsLsqt(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployTemporalCollectionsLsqt(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        File dir = configDir.getTemporalCollectionsLsqtDir();
        if (dir != null && dir.exists()) {
            for (File f : dir.listFiles(new ResourceFilenameFilter())) {
                String name = f.getName();
                String temporalCollectionName = name.replaceAll(".xml|.json", "");
                String payload = this.copyFileToString(f, context);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.format("Extracted temporal collection name '%s' from filename '%s'", new Object[]{temporalCollectionName, name}));
                }
                new TemporalCollectionLSQTManager(context.getManageClient(), databaseIdOrName, temporalCollectionName).save(payload);
            }
        } else {
            this.logResourceDirectoryNotFound(dir);
        }
    }
}

