/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.taskservers;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.taskservers.TaskServerManager;
import java.io.File;

public class UpdateTaskServerCommand
extends AbstractCommand {
    private String taskServerName = "TaskServer";

    public UpdateTaskServerCommand() {
        this.setExecuteSortOrder(SortOrderConstants.UPDATE_TASK_SERVER);
    }

    @Override
    public void execute(CommandContext context) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dir = configDir.getTaskServersDir();
            if (dir.exists()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Processing files in directory: " + dir.getAbsolutePath());
                }
                TaskServerManager mgr = new TaskServerManager(context.getManageClient());
                for (File f : this.listFilesInDirectory(dir)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Processing file: " + f.getAbsolutePath());
                    }
                    String payload = this.copyFileToString(f, context);
                    mgr.updateTaskServer(this.taskServerName, payload, context.getAdminManager());
                }
                continue;
            }
            this.logResourceDirectoryNotFound(dir);
        }
    }

    public void setTaskServerName(String taskServerName) {
        this.taskServerName = taskServerName;
    }
}

