/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.security.CertificateTemplateManager;

public class GenerateTemporaryCertificateCommand
extends AbstractCommand {
    private String templateIdOrName;
    private String commonName;
    private int validFor = 365;
    private String dnsName;
    private String ipAddress;
    private boolean ifNecessary = true;

    public GenerateTemporaryCertificateCommand() {
        this.setExecuteSortOrder(SortOrderConstants.GENERATE_TEMPORARY_CERTIFICATE);
    }

    @Override
    public void execute(CommandContext context) {
        if (this.templateIdOrName != null) {
            CertificateTemplateManager mgr = new CertificateTemplateManager(context.getManageClient());
            mgr.generateTemporaryCertificate(this.templateIdOrName, this.commonName, this.validFor, this.dnsName, this.ipAddress, this.ifNecessary);
        }
    }

    public String getTemplateIdOrName() {
        return this.templateIdOrName;
    }

    public void setTemplateIdOrName(String templateIdOrName) {
        this.templateIdOrName = templateIdOrName;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public int getValidFor() {
        return this.validFor;
    }

    public void setValidFor(int validFor) {
        this.validFor = validFor;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean isIfNecessary() {
        return this.ifNecessary;
    }

    public void setIfNecessary(boolean ifNecessary) {
        this.ifNecessary = ifNecessary;
    }
}

