/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.security.protectedpath.ProtectedPath;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.ProtectedPathManager;
import java.io.File;

public class DeployProtectedPathsCommand
extends AbstractResourceCommand
implements SupportsCmaCommand {
    public DeployProtectedPathsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_PROTECTED_PATHS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_PROTECTED_PATHS);
        this.setResourceClassType(ProtectedPath.class);
    }

    @Override
    public boolean cmaShouldBeUsed(CommandContext context) {
        return context.getAppConfig().getCmaConfig().isDeployProtectedPaths();
    }

    @Override
    public void addResourceToConfiguration(ObjectNode resource, Configuration configuration) {
        configuration.addProtectedPath(resource);
    }

    @Override
    protected void deployConfiguration(CommandContext context, Configuration config) {
        if (context.getAppConfig().getCmaConfig().isCombineRequests()) {
            this.logger.info("Adding protected paths to combined CMA request");
            context.addCmaConfigurationToCombinedRequest(config);
        } else {
            super.deployConfiguration(context, config);
        }
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getProtectedPathsDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new ProtectedPathManager(context.getManageClient());
    }
}

