/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.plugins;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.PluginConfig;
import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.document.BinaryDocumentManager;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.rest.util.Fragment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom2.Namespace;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class InstallPluginsCommand
extends AbstractUndoableCommand {
    public InstallPluginsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.INSTALL_PLUGINS);
        this.setUndoSortOrder(SortOrderConstants.UNINSTALL_PLUGINS);
    }

    @Override
    public void execute(CommandContext context) {
        List<String> paths = this.getPluginPaths(context);
        if (paths == null || paths.isEmpty()) {
            return;
        }
        DatabaseClient client = this.determineDatabaseClient(context.getAppConfig());
        for (String path : paths) {
            this.installPluginsInPath(path, context.getAppConfig(), client);
        }
    }

    @Override
    public void undo(CommandContext context) {
        List<String> paths = this.getPluginPaths(context);
        if (paths == null || paths.isEmpty()) {
            return;
        }
        DatabaseClient client = this.determineDatabaseClient(context.getAppConfig());
        for (String path : paths) {
            this.uninstallPluginsInPath(path, context.getAppConfig(), client);
        }
    }

    protected List<String> getPluginPaths(CommandContext context) {
        PluginConfig config = context.getAppConfig().getPluginConfig();
        if (config == null) {
            return null;
        }
        if (!config.isEnabled()) {
            this.logger.info("Installing/uninstalling plugins is disabled");
            return null;
        }
        return config.getPluginPaths();
    }

    protected void installPluginsInPath(String path, AppConfig appConfig, DatabaseClient client) {
        File pluginsDir = new File(path);
        if (pluginsDir == null || !pluginsDir.exists()) {
            return;
        }
        for (File dir : new File(path).listFiles()) {
            if (!dir.isDirectory()) continue;
            this.makePlugin(dir, appConfig);
            String binaryUri = this.insertPluginZip(dir, appConfig, client);
            if (binaryUri == null) continue;
            this.installPlugin(binaryUri, appConfig, client);
        }
    }

    protected void makePlugin(File dir, AppConfig appConfig) {
        String command = appConfig.getPluginConfig().getMakeCommand();
        this.logger.info(this.format("Invoking command '%s' in directory: %s", new Object[]{command, dir.getAbsolutePath()}));
        try {
            Process process = new ProcessBuilder(command).directory(dir).start();
            byte[] output = FileCopyUtils.copyToByteArray((InputStream)process.getInputStream());
            process.waitFor();
            this.logger.info(this.format("Output from executing command '%s': %s", new Object[]{command, new String(output)}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String insertPluginZip(File dir, AppConfig appConfig, DatabaseClient client) {
        BinaryDocumentManager binaryDocumentManager = client.newBinaryDocumentManager();
        File file = this.findPluginZipInDirectory(dir);
        if (file == null) {
            return null;
        }
        String uri = appConfig.getPluginConfig().getUriPrefix() + file.getName();
        this.logger.info("Writing plugin zip file to URI: " + uri);
        binaryDocumentManager.write(uri, (AbstractWriteHandle)new FileHandle(file));
        return uri;
    }

    protected File findPluginZipInDirectory(File dir) {
        File[] files = dir.listFiles((dir1, name) -> name.endsWith(".zip"));
        if (files.length == 0) {
            this.logger.info("No files ending in .zip found in directory: " + dir.getAbsolutePath());
            return null;
        }
        if (files.length > 1) {
            this.logger.info("Multiple files ending in .zip found in directory: " + dir.getAbsolutePath() + "; please ensure only a single .zip file is in the directory.");
            return null;
        }
        return files[0];
    }

    protected void installPlugin(String uri, AppConfig appConfig, DatabaseClient client) {
        String scope = appConfig.getPluginConfig().getScope();
        String script = appConfig.getPluginConfig().getInstallScript();
        ServerEvaluationCall eval = client.newServerEval().xquery(script).addVariable("uri", uri).addVariable("scope", scope);
        this.logger.info(this.format("Installing plugin with scope '%s' from URI '%s' via script: %s", new Object[]{scope, uri, script}));
        String result = (String)eval.evalAs(String.class);
        this.logger.info(this.format("Installed plugin with scope '%s', result: %s", new Object[]{scope, result}));
    }

    protected void uninstallPluginsInPath(String path, AppConfig appConfig, DatabaseClient client) {
        File pluginsDir = new File(path);
        if (pluginsDir == null || !pluginsDir.exists()) {
            return;
        }
        for (File dir : new File(path).listFiles()) {
            String pluginName;
            if (!dir.isDirectory() || (pluginName = this.getPluginName(dir, appConfig)) == null) continue;
            this.uninstallPlugin(pluginName, appConfig, client);
        }
    }

    protected String getPluginName(File dir, AppConfig appConfig) {
        File manifestFile = new File(dir, "manifest.xml");
        if (manifestFile == null || !manifestFile.exists()) {
            this.makePlugin(dir, appConfig);
            manifestFile = new File(dir, "manifest.xml");
        }
        try {
            String xml = new String(FileCopyUtils.copyToByteArray((File)manifestFile));
            Fragment manifest = new Fragment(xml, Namespace.getNamespace((String)"p", (String)"http://marklogic.com/extension/plugin"));
            return manifest.getElementValue("/p:plugin/p:name");
        }
        catch (IOException e) {
            this.logger.warn(this.format("Unable to get plugin name from dir: %s; cause: %s", new Object[]{dir.getAbsolutePath(), e.getMessage()}), (Throwable)e);
            return null;
        }
    }

    protected void uninstallPlugin(String pluginName, AppConfig appConfig, DatabaseClient client) {
        String scope = appConfig.getPluginConfig().getScope() + "/" + pluginName;
        String script = appConfig.getPluginConfig().getUninstallScript();
        ServerEvaluationCall eval = client.newServerEval().xquery(script).addVariable("scope", scope);
        this.logger.info(this.format("Uninstalling plugin with scope '%s' via script: %s", new Object[]{scope, script}));
        String result = (String)eval.evalAs(String.class);
        if (result != null && result.trim().length() > 0) {
            this.logger.info(this.format("Uninstalled plugin with scope '%s', result: %s", new Object[]{scope, result}));
        } else {
            this.logger.info(this.format("Uninstalled plugin with scope '%s'", new Object[]{scope}));
        }
    }

    protected DatabaseClient determineDatabaseClient(AppConfig appConfig) {
        PluginConfig config = appConfig.getPluginConfig();
        String databaseName = config.getDatabaseName();
        if (StringUtils.hasText((String)databaseName)) {
            this.logger.info("Will install plugins via App-Services port and database: " + databaseName);
            return appConfig.newAppServicesDatabaseClient(databaseName);
        }
        return appConfig.newDatabaseClient();
    }
}

