/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.modules;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.modules.DefaultModulesLoaderFactory;
import com.marklogic.appdeployer.command.modules.ModulesLoaderFactory;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.TestServerModulesFinder;
import java.util.List;

public class LoadModulesCommand
extends AbstractCommand {
    private ModulesLoader modulesLoader;
    private ModulesLoaderFactory modulesLoaderFactory;

    public LoadModulesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_MODULES);
        this.modulesLoaderFactory = new DefaultModulesLoaderFactory();
    }

    public void initializeDefaultModulesLoader(CommandContext context) {
        this.logger.info("Initializing new instance of ModulesLoader");
        this.modulesLoader = this.modulesLoaderFactory.newModulesLoader(context.getAppConfig());
    }

    @Override
    public void execute(CommandContext context) {
        this.loadModulesIntoMainServer(context);
        if (context.getAppConfig().isTestPortSet()) {
            this.loadModulesIntoTestServer(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadModulesIntoMainServer(CommandContext context) {
        if (this.modulesLoader == null) {
            this.initializeDefaultModulesLoader(context);
        }
        AppConfig config = context.getAppConfig();
        DatabaseClient client = config.newDatabaseClient();
        List<String> pathsList = config.getModulePaths();
        String[] pathsArray = pathsList.toArray(new String[0]);
        try {
            this.logger.info("Loading modules from paths: " + pathsList);
            this.modulesLoader.loadModules(client, (ModulesFinder)new DefaultModulesFinder(), pathsArray);
        }
        finally {
            client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadModulesIntoTestServer(CommandContext context) {
        AppConfig config = context.getAppConfig();
        DatabaseClient client = config.newTestDatabaseClient();
        ModulesLoader testLoader = this.buildTestModulesLoader(context);
        try {
            this.logger.info("Loading modules into test server from paths: " + config.getModulePaths());
            testLoader.loadModules(client, (ModulesFinder)new TestServerModulesFinder(), config.getModulePaths().toArray(new String[0]));
        }
        finally {
            client.release();
        }
    }

    protected ModulesLoader buildTestModulesLoader(CommandContext context) {
        DefaultModulesLoader l = new DefaultModulesLoader();
        l.setModulesManager(null);
        return l;
    }

    public void setModulesLoader(ModulesLoader modulesLoader) {
        this.modulesLoader = modulesLoader;
    }

    public ModulesLoader getModulesLoader() {
        return this.modulesLoader;
    }

    public void setModulesLoaderFactory(ModulesLoaderFactory modulesLoaderFactory) {
        this.modulesLoaderFactory = modulesLoaderFactory;
    }

    public ModulesLoaderFactory getModulesLoaderFactory() {
        return this.modulesLoaderFactory;
    }
}

