/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.modules;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.modules.ModulesLoaderFactory;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.batch.RestBatchWriter;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ModulesLoader;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.modulesloader.impl.StaticChecker;
import com.marklogic.client.ext.modulesloader.impl.XccStaticChecker;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.xcc.template.XccTemplate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DefaultModulesLoaderFactory
extends LoggingObject
implements ModulesLoaderFactory {
    @Override
    public ModulesLoader newModulesLoader(AppConfig appConfig) {
        Pattern modulesPattern;
        String[] extensions;
        String permissions;
        DatabaseClient modulesDatabaseClient = appConfig.newModulesDatabaseClient();
        PropertiesModuleManager modulesManager = null;
        String path = appConfig.getModuleTimestampsPath();
        if (path != null) {
            modulesManager = appConfig.isModuleTimestampsUseHost() ? new PropertiesModuleManager(path, modulesDatabaseClient) : new PropertiesModuleManager(path);
        }
        int threadCount = appConfig.getModulesLoaderThreadCount();
        RestBatchWriter assetBatchWriter = new RestBatchWriter(modulesDatabaseClient, false);
        assetBatchWriter.setThreadCount(threadCount);
        AssetFileLoader assetFileLoader = new AssetFileLoader((BatchWriter)assetBatchWriter, (ModulesManager)modulesManager);
        assetFileLoader.setCascadeCollections(appConfig.isCascadeCollections());
        assetFileLoader.setCascadePermissions(appConfig.isCascadePermissions());
        if (appConfig.getModulesLoaderBatchSize() != null) {
            assetFileLoader.setBatchSize(appConfig.getModulesLoaderBatchSize());
        }
        if ((permissions = appConfig.getModulePermissions()) != null) {
            assetFileLoader.setPermissions(permissions);
        }
        if ((extensions = appConfig.getAdditionalBinaryExtensions()) != null) {
            assetFileLoader.setAdditionalBinaryExtensions(extensions);
        }
        if (appConfig.getAssetFileFilter() != null) {
            assetFileLoader.addFileFilter(appConfig.getAssetFileFilter());
        }
        if (StringUtils.isNotBlank((CharSequence)appConfig.getModuleUriPrefix())) {
            assetFileLoader.addDocumentFileProcessor(documentFile -> {
                documentFile.setUri(appConfig.getModuleUriPrefix().trim() + documentFile.getUri());
                return documentFile;
            });
        }
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        if (appConfig.isReplaceTokensInModules()) {
            TokenReplacer tokenReplacer = appConfig.buildTokenReplacer();
            assetFileLoader.setTokenReplacer(tokenReplacer);
            modulesLoader.setTokenReplacer(tokenReplacer);
        }
        modulesLoader.setModulesManager((ModulesManager)modulesManager);
        modulesLoader.setTaskThreadCount(threadCount);
        if (appConfig.isStaticCheckAssets()) {
            modulesLoader.setStaticChecker(this.newStaticChecker(appConfig));
        }
        if ((modulesPattern = appConfig.getModuleFilenamesIncludePattern()) != null) {
            modulesLoader.setIncludeFilenamePattern(modulesPattern);
        }
        return modulesLoader;
    }

    protected StaticChecker newStaticChecker(AppConfig appConfig) {
        XccTemplate t = new XccTemplate(appConfig.getHost(), appConfig.getRestPort().intValue(), appConfig.getRestAdminUsername(), appConfig.getRestAdminPassword(), null);
        XccStaticChecker checker = new XccStaticChecker(t);
        checker.setBulkCheck(appConfig.isBulkLoadAssets());
        checker.setCheckLibraryModules(appConfig.isStaticCheckLibraryAssets());
        return checker;
    }
}

