/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.es;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.es.CodeGenerationRequest;
import com.marklogic.client.ext.es.EntityServicesManager;
import com.marklogic.client.ext.es.GeneratedCode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class GenerateModelArtifactsCommand
extends AbstractCommand {
    private String optionsPath = "options";

    public GenerateModelArtifactsCommand() {
        int order = SortOrderConstants.LOAD_SCHEMAS - 1;
        if (SortOrderConstants.LOAD_SCHEMAS > SortOrderConstants.LOAD_MODULES) {
            order = SortOrderConstants.LOAD_MODULES - 1;
        }
        this.setExecuteSortOrder(order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        String modelsPath = appConfig.getModelsPath();
        File modelsDir = new File(modelsPath);
        if (modelsDir.exists()) {
            DatabaseClient client = this.buildDatabaseClient(appConfig);
            try {
                EntityServicesManager mgr = new EntityServicesManager(client);
                for (File f : modelsDir.listFiles()) {
                    GeneratedCode code = this.loadModelDefinition(appConfig, f, mgr);
                    File modulesDir = this.selectModulesDir(appConfig);
                    modulesDir.mkdirs();
                    this.generateInstanceConverter(appConfig, code, modulesDir);
                    this.generateSearchOptions(code, modulesDir);
                    this.generateDatabaseProperties(appConfig, code);
                    this.generateSchema(appConfig, code);
                    this.generateExtractionTemplate(appConfig, code);
                }
            }
            finally {
                client.release();
            }
        }
    }

    protected DatabaseClient buildDatabaseClient(AppConfig appConfig) {
        String db = appConfig.getModelsDatabase();
        if (StringUtils.isEmpty((Object)db)) {
            db = appConfig.getContentDatabaseName();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Will load Entity Services models into database: " + db);
        }
        return appConfig.newAppServicesDatabaseClient(db);
    }

    protected GeneratedCode loadModelDefinition(AppConfig appConfig, File f, EntityServicesManager mgr) {
        return this.loadModelDefinition(this.buildCodeGenerationRequest(appConfig), f, mgr);
    }

    protected GeneratedCode loadModelDefinition(CodeGenerationRequest codeGenerationRequest, File f, EntityServicesManager mgr) {
        String name = f.getName();
        String modelDefinition = null;
        try {
            modelDefinition = new String(FileCopyUtils.copyToByteArray((File)f));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read model definition from file: " + f.getAbsolutePath(), e);
        }
        String modelUri = mgr.loadModel(name, modelDefinition);
        return mgr.generateCode(modelUri, codeGenerationRequest);
    }

    protected CodeGenerationRequest buildCodeGenerationRequest(AppConfig appConfig) {
        CodeGenerationRequest request = new CodeGenerationRequest();
        request.setGenerateDatabaseProperties(appConfig.isGenerateDatabaseProperties());
        request.setGenerateExtractionTemplate(appConfig.isGenerateExtractionTemplate());
        request.setGenerateInstanceConverter(appConfig.isGenerateInstanceConverter());
        request.setGenerateSchema(appConfig.isGenerateSchema());
        request.setGenerateSearchOptions(appConfig.isGenerateSearchOptions());
        return request;
    }

    protected File selectModulesDir(AppConfig appConfig) {
        List<String> modulePaths = appConfig.getModulePaths();
        String lastPath = modulePaths.get(modulePaths.size() - 1);
        return new File(lastPath);
    }

    protected void generateInstanceConverter(AppConfig appConfig, GeneratedCode code, File modulesDir) {
        String instanceConverter = code.getInstanceConverter();
        if (instanceConverter != null) {
            File esDir = new File(modulesDir, appConfig.getInstanceConverterPath());
            esDir.mkdirs();
            File out = new File(esDir, code.getTitle() + "-" + code.getVersion() + ".xqy");
            String logMessage = "Wrote instance converter to: ";
            if (out.exists()) {
                if (!this.fileHasDifferentContent(out, instanceConverter)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Instance converter matches file, so not modifying: " + out.getAbsolutePath());
                    }
                    return;
                }
                out = new File(esDir, code.getTitle() + "-" + code.getVersion() + ".xqy.GENERATED");
                logMessage = "Instance converter does not match existing file, so writing to: ";
            }
            try {
                FileCopyUtils.copy((byte[])instanceConverter.getBytes(), (File)out);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logMessage + out.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write instance converter to: " + out.getAbsolutePath(), e);
            }
        }
    }

    protected void generateSearchOptions(GeneratedCode code, File modulesDir) {
        String searchOptions = code.getSearchOptions();
        if (searchOptions != null) {
            File optionsDir = new File(modulesDir, this.optionsPath);
            optionsDir.mkdirs();
            File out = new File(optionsDir, code.getTitle() + ".xml");
            String logMessage = "Wrote search options to: ";
            if (out.exists()) {
                if (!this.fileHasDifferentContent(out, searchOptions)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Search options matches file, so not modifying: " + out.getAbsolutePath());
                    }
                    return;
                }
                out = new File(optionsDir, code.getTitle() + "xml.GENERATED");
                logMessage = "Search options does not match existing file, so writing to: ";
            }
            try {
                FileCopyUtils.copy((byte[])searchOptions.getBytes(), (File)out);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logMessage + out.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write search options to file: " + out.getAbsolutePath(), e);
            }
        }
    }

    protected void generateDatabaseProperties(AppConfig appConfig, GeneratedCode code) {
        String props = code.getDatabaseProperties();
        if (props != null) {
            File dbDir = appConfig.getFirstConfigDir().getDatabasesDir();
            dbDir.mkdirs();
            File out = new File(dbDir, "content-database.json");
            String logMessage = "Wrote database properties to: ";
            if (out.exists()) {
                if (!this.fileHasDifferentContent(out, props)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Database properties matches file, so not modifying: " + out.getAbsolutePath());
                    }
                    return;
                }
                out = new File(dbDir, "content-database.json.GENERATED");
                logMessage = "Database properties does not match existing file, so writing to: ";
            }
            try {
                File schemasFile;
                FileCopyUtils.copy((byte[])props.getBytes(), (File)out);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logMessage + out.getAbsolutePath());
                }
                if (!(schemasFile = new File(dbDir, "schemas-database.json")).exists()) {
                    String payload = "{\"database-name\": \"%%SCHEMAS_DATABASE%%\"}";
                    try {
                        FileCopyUtils.copy((byte[])payload.getBytes(), (File)schemasFile);
                    }
                    catch (IOException ex) {
                        this.logger.warn("Unable to write schemas database payload to file: " + schemasFile.getAbsolutePath(), (Throwable)ex);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write database properties to file: " + out.getAbsolutePath(), e);
            }
        }
    }

    protected void generateSchema(AppConfig appConfig, GeneratedCode code) {
        String schema = code.getSchema();
        if (schema != null) {
            File dir = new File(appConfig.getSchemaPaths().get(0));
            dir.mkdirs();
            File out = new File(dir, code.getTitle() + "-" + code.getVersion() + ".xsd");
            String logMessage = "Wrote schema to: ";
            if (out.exists()) {
                if (!this.fileHasDifferentContent(out, schema)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Schema matches file, so not modifying: " + out.getAbsolutePath());
                    }
                    return;
                }
                out = new File(dir, code.getTitle() + "-" + code.getVersion() + "xsd.GENERATED");
                logMessage = "Schema does not match existing file, so writing to: ";
            }
            try {
                FileCopyUtils.copy((byte[])schema.getBytes(), (File)out);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logMessage + out.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write schema to file: " + out.getAbsolutePath(), e);
            }
        }
    }

    protected void generateExtractionTemplate(AppConfig appConfig, GeneratedCode code) {
        String template = code.getExtractionTemplate();
        if (template != null) {
            File dir = new File(appConfig.getSchemaPaths().get(0));
            dir.mkdirs();
            dir = new File(dir, "tde");
            dir.mkdirs();
            File out = new File(dir, code.getTitle() + "-" + code.getVersion() + ".tdex");
            String logMessage = "Wrote extraction template to: ";
            if (out.exists()) {
                if (!this.fileHasDifferentContent(out, template)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Extraction template matches file, so not modifying: " + out.getAbsolutePath());
                    }
                    return;
                }
                out = new File(dir, code.getTitle() + "-" + code.getVersion() + "tdex.GENERATED");
                logMessage = "Extraction template does not match existing file, so writing to: ";
            }
            try {
                FileCopyUtils.copy((byte[])template.getBytes(), (File)out);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logMessage + out.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write extraction template to file: " + out.getAbsolutePath(), e);
            }
        }
    }

    protected boolean fileHasDifferentContent(File existingFile, String content) {
        try {
            String fileContent = this.copyFileToString(existingFile);
            fileContent = this.removeGeneratedAtTimestamp(fileContent);
            content = this.removeGeneratedAtTimestamp(content);
            return !fileContent.equals(content);
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    protected String removeGeneratedAtTimestamp(String content) {
        int pos = content.indexOf("Generated at timestamp");
        if (pos > -1) {
            int end = content.indexOf(":)", pos);
            return content.substring(0, pos) + content.substring(end + 2);
        }
        return content;
    }

    public void setOptionsPath(String optionsPath) {
        this.optionsPath = optionsPath;
    }
}

