/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.databases;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandFactory;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import java.io.File;
import java.util.ArrayList;

public class DeploySubDatabasesCommand
extends AbstractUndoableCommand {
    private DeployDatabaseCommandFactory deployDatabaseCommandFactory;
    private String superDatabaseName;

    public DeploySubDatabasesCommand(String superDatabaseName, DeployDatabaseCommandFactory deployDatabaseCommandFactory) {
        this.superDatabaseName = superDatabaseName;
        this.deployDatabaseCommandFactory = deployDatabaseCommandFactory;
    }

    @Override
    public void execute(CommandContext context) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File subdbDir = new File(configDir.getDatabasesDir() + File.separator + "subdatabases" + File.separator + this.superDatabaseName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.format("Checking for sub-databases in: %s for database: %s", new Object[]{subdbDir.getAbsolutePath(), this.superDatabaseName}));
            }
            if (!subdbDir.exists()) continue;
            ArrayList<String> subDbNames = new ArrayList<String>();
            for (File subDatabaseFile : this.listFilesInDirectory(subdbDir)) {
                this.logger.info(this.format("Processing sub-database for %s found in file: %s", new Object[]{this.superDatabaseName, subDatabaseFile.getAbsolutePath()}));
                DeployDatabaseCommand subDbCommand = this.deployDatabaseCommandFactory.newDeployDatabaseCommand(subDatabaseFile);
                subDbCommand.setSupportsResourceMerging(false);
                subDbCommand.setDatabaseFile(subDatabaseFile);
                subDbCommand.setSuperDatabaseName(this.superDatabaseName);
                subDbCommand.setSubDatabase(true);
                subDbCommand.execute(context);
                subDbNames.add(subDbCommand.getDatabaseName());
                this.logger.info(this.format("Created sub-database %s for database %s", new Object[]{subDbCommand.getDatabaseName(), this.superDatabaseName}));
            }
            if (subDbNames.size() <= 0) continue;
            new DatabaseManager(context.getManageClient()).attachSubDatabases(this.superDatabaseName, subDbNames);
        }
    }

    @Override
    public void undo(CommandContext context) {
        DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File subdbDir = new File(configDir.getDatabasesDir() + File.separator + "subdatabases" + File.separator + this.superDatabaseName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.format("Checking to see if %s has sub-databases that need to be removed. Looking in: %s", new Object[]{this.superDatabaseName, subdbDir.getAbsolutePath()}));
            }
            if (!subdbDir.exists()) continue;
            this.logger.info("Removing all sub-databases from database: " + this.superDatabaseName);
            dbMgr.detachSubDatabases(this.superDatabaseName);
            for (File f : this.listFilesInDirectory(subdbDir)) {
                DeployDatabaseCommand subDbCommand = this.deployDatabaseCommandFactory.newDeployDatabaseCommand(null);
                subDbCommand.setDatabaseFile(f);
                subDbCommand.setSuperDatabaseName(this.superDatabaseName);
                subDbCommand.setSubDatabase(true);
                subDbCommand.undo(context);
            }
        }
    }
}

