/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.databases;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.mgmt.api.database.Database;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DatabasePlan {
    private String databaseName;
    private List<File> files;
    private boolean mainContentDatabase;
    private boolean testContentDatabase;
    private String payload;
    private ObjectNode mergedObjectNode;
    private Database databaseForSorting;
    private DeployDatabaseCommand deployDatabaseCommand;

    public DatabasePlan(String databaseName, List<File> files) {
        this.databaseName = databaseName;
        this.files = files;
    }

    public DatabasePlan(String databaseName, File file, boolean mainContentDatabase) {
        this.databaseName = databaseName;
        this.addFile(file);
        this.mainContentDatabase = mainContentDatabase;
    }

    public void addFile(File f) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        if (!this.files.contains(f)) {
            this.files.add(f);
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public File getLastFile() {
        if (this.files == null || this.files.isEmpty()) {
            return null;
        }
        return this.files.get(this.files.size() - 1);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public boolean isMainContentDatabase() {
        return this.mainContentDatabase;
    }

    public void setMainContentDatabase(boolean mainContentDatabase) {
        this.mainContentDatabase = mainContentDatabase;
    }

    public boolean isTestContentDatabase() {
        return this.testContentDatabase;
    }

    public void setTestContentDatabase(boolean testContentDatabase) {
        this.testContentDatabase = testContentDatabase;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public ObjectNode getMergedObjectNode() {
        return this.mergedObjectNode;
    }

    public void setMergedObjectNode(ObjectNode mergedObjectNode) {
        this.mergedObjectNode = mergedObjectNode;
        this.payload = mergedObjectNode.toString();
    }

    public Database getDatabaseForSorting() {
        return this.databaseForSorting;
    }

    public void setDatabaseForSorting(Database databaseForSorting) {
        this.databaseForSorting = databaseForSorting;
    }

    public DeployDatabaseCommand getDeployDatabaseCommand() {
        return this.deployDatabaseCommand;
    }

    public void setDeployDatabaseCommand(DeployDatabaseCommand deployDatabaseCommand) {
        this.deployDatabaseCommand = deployDatabaseCommand;
    }

    public String toString() {
        return "DatabasePlan{databaseName='" + this.databaseName + '\'' + ", files=" + this.files + ", mainContentDatabase=" + this.mainContentDatabase + '}';
    }
}

