/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.clusters;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.clusters.ClusterManager;
import java.io.File;

public class ModifyLocalClusterCommand
extends AbstractCommand {
    public ModifyLocalClusterCommand() {
        this.setExecuteSortOrder(SortOrderConstants.MODIFY_LOCAL_CLUSTER);
    }

    @Override
    public void execute(CommandContext context) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File clustersDir = configDir.getClustersDir();
            if (clustersDir != null && clustersDir.exists()) {
                for (File f : clustersDir.listFiles()) {
                    if (!f.isFile() || !f.getName().startsWith("local-cluster")) continue;
                    String payload = this.copyFileToString(f, context);
                    new ClusterManager(context.getManageClient()).modifyLocalCluster(payload, context.getAdminManager());
                }
                continue;
            }
            this.logResourceDirectoryNotFound(clustersDir);
        }
    }
}

