/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PluginConfig {
    public static final String DEFAULT_PLUGIN_PATH = "src/main/ml-plugins";
    public static final String DEFAULT_PLUGIN_URI_PREFIX = "/com.marklogic/plugins/";
    public static final String DEFAULT_INSTALL_SCRIPT = "import module namespace plugin = 'http://marklogic.com/extension/plugin' at 'MarkLogic/plugin/plugin.xqy'; declare variable $uri external; declare variable $scope external; plugin:install-from-zip($scope, fn:doc($uri)/node())";
    public static final String DEFAULT_UNINSTALL_SCRIPT = "import module namespace plugin = 'http://marklogic.com/extension/plugin' at 'MarkLogic/plugin/plugin.xqy'; declare variable $scope external; plugin:uninstall($scope)";
    private List<String> pluginPaths;
    private boolean enabled = true;
    private String databaseName;
    private String uriPrefix = "/com.marklogic/plugins/";
    private String installScript = "import module namespace plugin = 'http://marklogic.com/extension/plugin' at 'MarkLogic/plugin/plugin.xqy'; declare variable $uri external; declare variable $scope external; plugin:install-from-zip($scope, fn:doc($uri)/node())";
    private String uninstallScript = "import module namespace plugin = 'http://marklogic.com/extension/plugin' at 'MarkLogic/plugin/plugin.xqy'; declare variable $scope external; plugin:uninstall($scope)";
    private String makeCommand = "make";
    private String scope = "native";
    private File projectDir;

    public PluginConfig(File projectDir) {
        this.projectDir = projectDir;
        this.pluginPaths = new ArrayList<String>();
        String path = projectDir != null ? new File(projectDir, DEFAULT_PLUGIN_PATH).getAbsolutePath() : DEFAULT_PLUGIN_PATH;
        this.pluginPaths.add(path);
    }

    public List<String> getPluginPaths() {
        return this.pluginPaths;
    }

    public void setPluginPaths(List<String> pluginPaths) {
        this.pluginPaths = pluginPaths;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public String getInstallScript() {
        return this.installScript;
    }

    public void setInstallScript(String installScript) {
        this.installScript = installScript;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public void setMakeCommand(String makeCommand) {
        this.makeCommand = makeCommand;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getUninstallScript() {
        return this.uninstallScript;
    }

    public void setUninstallScript(String uninstallScript) {
        this.uninstallScript = uninstallScript;
    }

    public File getProjectDir() {
        return this.projectDir;
    }
}

